/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec;
import it.auties.whatsapp.model.signal.sender.SenderChainKey;
import it.auties.whatsapp.model.signal.sender.SenderChainKeySpec;
import it.auties.whatsapp.model.signal.sender.SenderKeyState;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import it.auties.whatsapp.model.signal.sender.SenderMessageKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SenderKeyStateSpec {
    public static byte[] encode(SenderKeyState protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeInt32(1, Integer.valueOf(protoInputObject.id()));
        outputStream.writeBytes(2, SignalKeyPairSpec.encode(protoInputObject.signingKey()));
        if (protoInputObject.messageKeys() != null) {
            for (Map.Entry<Integer, SenderMessageKey> messageKeysEntry : protoInputObject.messageKeys().entrySet()) {
                ProtobufOutputStream messageKeysOutputStream = new ProtobufOutputStream();
                messageKeysOutputStream.writeInt32(1, messageKeysEntry.getKey());
                messageKeysOutputStream.writeBytes(2, SenderMessageKeySpec.encode(messageKeysEntry.getValue()));
                outputStream.writeBytes(3, messageKeysOutputStream.toByteArray());
            }
        }
        outputStream.writeBytes(4, SenderChainKeySpec.encode(protoInputObject.chainKey()));
        return outputStream.toByteArray();
    }

    public static SenderKeyState decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        int id = 0;
        SignalKeyPair signingKey = null;
        ConcurrentHashMap<Integer, SenderMessageKey> messageKeys = new ConcurrentHashMap<Integer, SenderMessageKey>();
        SenderChainKey chainKey = null;
        block10: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    id = inputStream.readInt32();
                    continue block10;
                }
                case 2: {
                    signingKey = SignalKeyPairSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 3: {
                    ProtobufInputStream messageKeysInputStream = new ProtobufInputStream(inputStream.readBytes());
                    Integer messageKeysKey = null;
                    SenderMessageKey messageKeysValue = null;
                    while (messageKeysInputStream.readTag()) {
                        switch (messageKeysInputStream.index()) {
                            case 1: {
                                messageKeysKey = messageKeysInputStream.readInt32();
                                break;
                            }
                            case 2: {
                                messageKeysValue = SenderMessageKeySpec.decode(messageKeysInputStream.readBytes());
                            }
                        }
                    }
                    messageKeys.put(messageKeysKey, messageKeysValue);
                    continue block10;
                }
                case 4: {
                    chainKey = SenderChainKeySpec.decode(inputStream.readBytes());
                    continue block10;
                }
            }
            inputStream.skipBytes();
        }
        return new SenderKeyState(id, signingKey, messageKeys, chainKey);
    }
}

