/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.session;

import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.signal.session.SessionState;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class Session
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.OBJECT)
    private final ConcurrentHashMap.KeySetView<SessionState, Boolean> states;

    public Session() {
        this(ConcurrentHashMap.newKeySet());
    }

    public Session(ConcurrentHashMap.KeySetView<SessionState, Boolean> states) {
        Objects.requireNonNull(states);
        this.states = states;
    }

    public Session closeCurrentState() {
        Optional<SessionState> currentState = this.currentState();
        currentState.ifPresent(value -> value.closed(true));
        return this;
    }

    public Collection<SessionState> states() {
        return Collections.unmodifiableCollection(this.states);
    }

    public Optional<SessionState> currentState() {
        return this.states.stream().filter(state -> !state.closed()).findFirst();
    }

    public boolean hasState(int version, byte[] baseKey) {
        return this.states.stream().anyMatch(state -> state.contentEquals(version, baseKey));
    }

    public Optional<SessionState> findState(int version, byte[] baseKey) {
        return this.states.stream().filter(state -> state.contentEquals(version, baseKey)).findFirst();
    }

    public void addState(SessionState state) {
        this.states.add(state);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Session that = (Session)obj;
        return Objects.equals(this.states, that.states);
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public String toString() {
        return "Session[states=" + String.valueOf(this.states) + "]";
    }
}

