/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.session;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec;
import it.auties.whatsapp.model.signal.session.SessionChain;
import it.auties.whatsapp.model.signal.session.SessionChainSpec;
import it.auties.whatsapp.model.signal.session.SessionPreKey;
import it.auties.whatsapp.model.signal.session.SessionPreKeySpec;
import it.auties.whatsapp.model.signal.session.SessionState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionStateSpec {
    public static byte[] encode(SessionState protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeInt32(1, Integer.valueOf(protoInputObject.version()));
        outputStream.writeInt32(2, Integer.valueOf(protoInputObject.registrationId()));
        outputStream.writeBytes(3, protoInputObject.baseKey());
        outputStream.writeBytes(4, protoInputObject.remoteIdentityKey());
        if (protoInputObject.chains() != null) {
            for (Map.Entry<String, SessionChain> chainsEntry : protoInputObject.chains().entrySet()) {
                ProtobufOutputStream chainsOutputStream = new ProtobufOutputStream();
                chainsOutputStream.writeString(1, chainsEntry.getKey());
                chainsOutputStream.writeBytes(2, SessionChainSpec.encode(chainsEntry.getValue()));
                outputStream.writeBytes(5, chainsOutputStream.toByteArray());
            }
        }
        outputStream.writeBytes(6, protoInputObject.rootKey());
        outputStream.writeBytes(7, SessionPreKeySpec.encode(protoInputObject.pendingPreKey()));
        outputStream.writeBytes(8, SignalKeyPairSpec.encode(protoInputObject.ephemeralKeyPair()));
        outputStream.writeBytes(9, protoInputObject.lastRemoteEphemeralKey());
        outputStream.writeInt32(10, Integer.valueOf(protoInputObject.previousCounter()));
        outputStream.writeBool(11, Boolean.valueOf(protoInputObject.closed()));
        return outputStream.toByteArray();
    }

    public static SessionState decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        int version = 0;
        int registrationId = 0;
        byte[] baseKey = null;
        byte[] remoteIdentityKey = null;
        ConcurrentHashMap<String, SessionChain> chains = new ConcurrentHashMap<String, SessionChain>();
        byte[] rootKey = null;
        SessionPreKey pendingPreKey = null;
        SignalKeyPair ephemeralKeyPair = null;
        byte[] lastRemoteEphemeralKey = null;
        int previousCounter = 0;
        boolean closed = false;
        block17: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    version = inputStream.readInt32();
                    continue block17;
                }
                case 2: {
                    registrationId = inputStream.readInt32();
                    continue block17;
                }
                case 3: {
                    baseKey = inputStream.readBytes();
                    continue block17;
                }
                case 4: {
                    remoteIdentityKey = inputStream.readBytes();
                    continue block17;
                }
                case 5: {
                    ProtobufInputStream chainsInputStream = new ProtobufInputStream(inputStream.readBytes());
                    String chainsKey = null;
                    SessionChain chainsValue = null;
                    while (chainsInputStream.readTag()) {
                        switch (chainsInputStream.index()) {
                            case 1: {
                                chainsKey = chainsInputStream.readString();
                                break;
                            }
                            case 2: {
                                chainsValue = SessionChainSpec.decode(chainsInputStream.readBytes());
                            }
                        }
                    }
                    chains.put(chainsKey, chainsValue);
                    continue block17;
                }
                case 6: {
                    rootKey = inputStream.readBytes();
                    continue block17;
                }
                case 7: {
                    pendingPreKey = SessionPreKeySpec.decode(inputStream.readBytes());
                    continue block17;
                }
                case 8: {
                    ephemeralKeyPair = SignalKeyPairSpec.decode(inputStream.readBytes());
                    continue block17;
                }
                case 9: {
                    lastRemoteEphemeralKey = inputStream.readBytes();
                    continue block17;
                }
                case 10: {
                    previousCounter = inputStream.readInt32();
                    continue block17;
                }
                case 11: {
                    closed = inputStream.readBool();
                    continue block17;
                }
            }
            inputStream.skipBytes();
        }
        return new SessionState(version, registrationId, baseKey, remoteIdentityKey, chains, rootKey, pendingPreKey, ephemeralKeyPair, lastRemoteEphemeralKey, previousCounter, closed);
    }
}

