/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatSpec;
import it.auties.whatsapp.model.chat.GroupPastParticipants;
import it.auties.whatsapp.model.chat.GroupPastParticipantsSpec;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoSpec;
import it.auties.whatsapp.model.setting.GlobalSettings;
import it.auties.whatsapp.model.setting.GlobalSettingsSpec;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.HistorySyncTypeSpec;
import it.auties.whatsapp.model.sync.PushName;
import it.auties.whatsapp.model.sync.PushNameSpec;
import it.auties.whatsapp.model.sync.StickerMetadata;
import it.auties.whatsapp.model.sync.StickerMetadataSpec;
import java.util.ArrayList;
import java.util.Objects;

public class HistorySyncSpec {
    public static byte[] encode(HistorySync protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        Objects.requireNonNull(protoInputObject.syncType(), "Missing required property: syncType");
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeInt32(1, HistorySyncTypeSpec.encode(protoInputObject.syncType()));
        if (protoInputObject.conversations() != null) {
            for (Chat conversationsEntry : protoInputObject.conversations()) {
                outputStream.writeBytes(2, ChatSpec.encode(conversationsEntry));
            }
        }
        if (protoInputObject.statusV3Messages() != null) {
            for (ChatMessageInfo statusV3MessagesEntry : protoInputObject.statusV3Messages()) {
                outputStream.writeBytes(3, ChatMessageInfoSpec.encode(statusV3MessagesEntry));
            }
        }
        outputStream.writeUInt32(5, Integer.valueOf(protoInputObject.chunkOrder()));
        outputStream.writeUInt32(6, protoInputObject.progress());
        if (protoInputObject.pushNames() != null) {
            for (PushName pushNamesEntry : protoInputObject.pushNames()) {
                outputStream.writeBytes(7, PushNameSpec.encode(pushNamesEntry));
            }
        }
        outputStream.writeBytes(8, GlobalSettingsSpec.encode(protoInputObject.globalSettings()));
        outputStream.writeBytes(9, protoInputObject.threadIdUserSecret());
        outputStream.writeUInt32(10, Integer.valueOf(protoInputObject.threadDsTimeframeOffset()));
        if (protoInputObject.recentStickers() != null) {
            for (StickerMetadata recentStickersEntry : protoInputObject.recentStickers()) {
                outputStream.writeBytes(11, StickerMetadataSpec.encode(recentStickersEntry));
            }
        }
        if (protoInputObject.pastParticipants() != null) {
            for (GroupPastParticipants pastParticipantsEntry : protoInputObject.pastParticipants()) {
                outputStream.writeBytes(12, GroupPastParticipantsSpec.encode(pastParticipantsEntry));
            }
        }
        return outputStream.toByteArray();
    }

    public static HistorySync decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        HistorySync.Type syncType = null;
        ArrayList<Chat> conversations = new ArrayList<Chat>();
        ArrayList<ChatMessageInfo> statusV3Messages = new ArrayList<ChatMessageInfo>();
        int chunkOrder = 0;
        Integer progress = null;
        ArrayList<PushName> pushNames = new ArrayList<PushName>();
        GlobalSettings globalSettings = null;
        byte[] threadIdUserSecret = null;
        int threadDsTimeframeOffset = 0;
        ArrayList<StickerMetadata> recentStickers = new ArrayList<StickerMetadata>();
        ArrayList<GroupPastParticipants> pastParticipants = new ArrayList<GroupPastParticipants>();
        block13: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    syncType = HistorySyncTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block13;
                }
                case 2: {
                    conversations.add(ChatSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 3: {
                    statusV3Messages.add(ChatMessageInfoSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 5: {
                    chunkOrder = inputStream.readInt32();
                    continue block13;
                }
                case 6: {
                    progress = inputStream.readInt32();
                    continue block13;
                }
                case 7: {
                    pushNames.add(PushNameSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 8: {
                    globalSettings = GlobalSettingsSpec.decode(inputStream.readBytes());
                    continue block13;
                }
                case 9: {
                    threadIdUserSecret = inputStream.readBytes();
                    continue block13;
                }
                case 10: {
                    threadDsTimeframeOffset = inputStream.readInt32();
                    continue block13;
                }
                case 11: {
                    recentStickers.add(StickerMetadataSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
                case 12: {
                    pastParticipants.add(GroupPastParticipantsSpec.decode(inputStream.readBytes()));
                    continue block13;
                }
            }
            inputStream.skipBytes();
        }
        Objects.requireNonNull(syncType, "Missing required property: syncType");
        return new HistorySync(syncType, conversations, statusV3Messages, chunkOrder, progress, pushNames, globalSettings, threadIdUserSecret, threadDsTimeframeOffset, recentStickers, pastParticipants);
    }
}

