/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.ExitCode;
import it.auties.whatsapp.model.sync.ExitCodeSpec;
import it.auties.whatsapp.model.sync.ExternalBlobReference;
import it.auties.whatsapp.model.sync.ExternalBlobReferenceSpec;
import it.auties.whatsapp.model.sync.KeyId;
import it.auties.whatsapp.model.sync.KeyIdSpec;
import it.auties.whatsapp.model.sync.MutationSync;
import it.auties.whatsapp.model.sync.MutationSyncSpec;
import it.auties.whatsapp.model.sync.PatchSync;
import it.auties.whatsapp.model.sync.VersionSync;
import it.auties.whatsapp.model.sync.VersionSyncSpec;
import java.util.ArrayList;

public class PatchSyncSpec {
    public static byte[] encode(PatchSync protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, VersionSyncSpec.encode(protoInputObject.version()));
        if (protoInputObject.mutations() != null) {
            for (MutationSync mutationsEntry : protoInputObject.mutations()) {
                outputStream.writeBytes(2, MutationSyncSpec.encode(mutationsEntry));
            }
        }
        outputStream.writeBytes(3, ExternalBlobReferenceSpec.encode(protoInputObject.externalMutations()));
        outputStream.writeBytes(4, protoInputObject.snapshotMac());
        outputStream.writeBytes(5, protoInputObject.patchMac());
        outputStream.writeBytes(6, KeyIdSpec.encode(protoInputObject.keyId()));
        outputStream.writeBytes(7, ExitCodeSpec.encode(protoInputObject.exitCode()));
        outputStream.writeUInt32(8, protoInputObject.deviceIndex());
        return outputStream.toByteArray();
    }

    public static PatchSync decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        VersionSync version = null;
        ArrayList<MutationSync> mutations = new ArrayList<MutationSync>();
        ExternalBlobReference externalMutations = null;
        byte[] snapshotMac = null;
        byte[] patchMac = null;
        KeyId keyId = null;
        ExitCode exitCode = null;
        Integer deviceIndex = null;
        block10: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    version = VersionSyncSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 2: {
                    mutations.add(MutationSyncSpec.decode(inputStream.readBytes()));
                    continue block10;
                }
                case 3: {
                    externalMutations = ExternalBlobReferenceSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 4: {
                    snapshotMac = inputStream.readBytes();
                    continue block10;
                }
                case 5: {
                    patchMac = inputStream.readBytes();
                    continue block10;
                }
                case 6: {
                    keyId = KeyIdSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 7: {
                    exitCode = ExitCodeSpec.decode(inputStream.readBytes());
                    continue block10;
                }
                case 8: {
                    deviceIndex = inputStream.readInt32();
                    continue block10;
                }
            }
            inputStream.skipBytes();
        }
        return new PatchSync(version, mutations, externalMutations, snapshotMac, patchMac, keyId, exitCode, deviceIndex);
    }
}

