/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.curve25519.Curve25519;
import it.auties.protobuf.exception.ProtobufDeserializationException;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.CountryLocale;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.signal.auth.ClientFinish;
import it.auties.whatsapp.model.signal.auth.ClientPayload;
import it.auties.whatsapp.model.signal.auth.ClientPayloadBuilder;
import it.auties.whatsapp.model.signal.auth.ClientPayloadSpec;
import it.auties.whatsapp.model.signal.auth.CompanionProperties;
import it.auties.whatsapp.model.signal.auth.CompanionPropertiesBuilder;
import it.auties.whatsapp.model.signal.auth.CompanionPropertiesSpec;
import it.auties.whatsapp.model.signal.auth.CompanionRegistrationData;
import it.auties.whatsapp.model.signal.auth.CompanionRegistrationDataBuilder;
import it.auties.whatsapp.model.signal.auth.DNSSource;
import it.auties.whatsapp.model.signal.auth.DNSSourceBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessage;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageBuilder;
import it.auties.whatsapp.model.signal.auth.HandshakeMessageSpec;
import it.auties.whatsapp.model.signal.auth.ServerHello;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.UserAgentBuilder;
import it.auties.whatsapp.model.signal.auth.WebInfo;
import it.auties.whatsapp.model.signal.auth.WebInfoBuilder;
import it.auties.whatsapp.model.sync.HistorySyncConfig;
import it.auties.whatsapp.model.sync.HistorySyncConfigBuilder;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.socket.SocketHandshake;
import it.auties.whatsapp.socket.SocketRequest;
import it.auties.whatsapp.socket.SocketSession;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Specification;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;

class AuthHandler {
    private final SocketHandler socketHandler;

    AuthHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    protected CompletableFuture<Boolean> login(SocketSession session, byte[] message) {
        try {
            Optional<ServerHello> serverHello = this.readHandshake(message);
            if (serverHello.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            SocketHandshake handshake = new SocketHandshake(this.socketHandler.keys(), this.getPrologueData());
            handshake.updateHash(this.socketHandler.keys().ephemeralKeyPair().publicKey());
            handshake.updateHash(serverHello.get().ephemeral());
            byte[] sharedEphemeral = Curve25519.sharedKey((byte[])serverHello.get().ephemeral(), (byte[])this.socketHandler.keys().ephemeralKeyPair().privateKey());
            handshake.mixIntoKey(sharedEphemeral);
            byte[] decodedStaticText = handshake.cipher(serverHello.get().staticText(), false);
            byte[] sharedStatic = Curve25519.sharedKey((byte[])decodedStaticText, (byte[])this.socketHandler.keys().ephemeralKeyPair().privateKey());
            handshake.mixIntoKey(sharedStatic);
            handshake.cipher(serverHello.get().payload(), false);
            byte[] encodedKey = handshake.cipher(this.socketHandler.keys().noiseKeyPair().publicKey(), true);
            byte[] sharedPrivate = Curve25519.sharedKey((byte[])serverHello.get().ephemeral(), (byte[])this.socketHandler.keys().noiseKeyPair().privateKey());
            handshake.mixIntoKey(sharedPrivate);
            ClientPayload payload = this.createUserClientPayload();
            byte[] encodedPayload = handshake.cipher(ClientPayloadSpec.encode(payload), true);
            ClientFinish clientFinish = new ClientFinish(encodedKey, encodedPayload);
            HandshakeMessage handshakeMessage = new HandshakeMessageBuilder().clientFinish(clientFinish).build();
            return this.sendHandshake(session, handshake, handshakeMessage);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private byte[] getPrologueData() {
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> Specification.Whatsapp.WEB_PROLOGUE;
            case ClientType.MOBILE -> Specification.Whatsapp.MOBILE_PROLOGUE;
        };
    }

    private Optional<ServerHello> readHandshake(byte[] message) {
        try {
            HandshakeMessage handshakeMessage = HandshakeMessageSpec.decode(message);
            return Optional.ofNullable(handshakeMessage.serverHello());
        }
        catch (ProtobufDeserializationException exception) {
            return Optional.empty();
        }
    }

    private CompletableFuture<Boolean> sendHandshake(SocketSession session, SocketHandshake handshake, HandshakeMessage handshakeMessage) {
        return SocketRequest.of(HandshakeMessageSpec.encode(handshakeMessage)).sendWithNoResponse(session, this.socketHandler.keys(), this.socketHandler.store()).thenApplyAsync(result -> this.onHandshakeSent(handshake));
    }

    private boolean onHandshakeSent(SocketHandshake handshake) {
        this.socketHandler.keys().clearReadWriteKey();
        handshake.finish();
        return true;
    }

    private WebInfo createWebInfo() {
        return new WebInfoBuilder().webSubPlatform(WebInfo.Platform.WEB_BROWSER).build();
    }

    private UserAgent createUserAgent() {
        boolean mobile = this.socketHandler.store().clientType() == ClientType.MOBILE;
        return new UserAgentBuilder().platform(this.socketHandler.store().device().platform()).appVersion(this.socketHandler.store().version()).mcc("000").mnc("000").osVersion(mobile ? this.socketHandler.store().device().osVersion().toString() : null).manufacturer(mobile ? this.socketHandler.store().device().manufacturer() : null).device(mobile ? this.socketHandler.store().device().model().replaceAll("_", " ") : null).osBuildNumber(mobile ? this.socketHandler.store().device().osVersion().toString() : null).phoneId(mobile ? this.socketHandler.keys().fdid() : null).releaseChannel(this.socketHandler.store().releaseChannel()).localeLanguageIso6391(this.socketHandler.store().locale().map(CountryLocale::languageValue).orElse("en")).localeCountryIso31661Alpha2(this.socketHandler.store().locale().map(CountryLocale::languageCode).orElse("US")).deviceType(UserAgent.DeviceType.PHONE).build();
    }

    private ClientPayload createUserClientPayload() {
        UserAgent agent = this.createUserAgent();
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.MOBILE -> {
                Long phoneNumber = this.socketHandler.store().phoneNumber().map(PhoneNumber::number).orElseThrow(() -> new NoSuchElementException("Missing phone number for mobile registration"));
                yield new ClientPayloadBuilder().username(phoneNumber).passive(true).userAgent(agent).pushName(this.socketHandler.store().name()).sessionId(ThreadLocalRandom.current().nextInt(100000000, 1000000000)).shortConnect(true).connectReason(ClientPayload.ClientPayloadConnectReason.USER_ACTIVATED).connectType(ClientPayload.ClientPayloadConnectType.WIFI_UNKNOWN).dnsSource(this.getDnsSource()).connectAttemptCount(ThreadLocalRandom.current().nextInt(5, 20)).device(0).oc(false).build();
            }
            case ClientType.WEB -> {
                Optional<Jid> jid = this.socketHandler.store().jid();
                if (jid.isPresent()) {
                    yield new ClientPayloadBuilder().connectReason(ClientPayload.ClientPayloadConnectReason.USER_ACTIVATED).connectType(ClientPayload.ClientPayloadConnectType.WIFI_UNKNOWN).userAgent(agent).webInfo(this.createWebInfo()).username(Long.parseLong(jid.get().user())).passive(true).pull(true).device(jid.get().device()).build();
                }
                yield new ClientPayloadBuilder().connectReason(ClientPayload.ClientPayloadConnectReason.USER_ACTIVATED).connectType(ClientPayload.ClientPayloadConnectType.WIFI_UNKNOWN).userAgent(agent).webInfo(this.createWebInfo()).regData(this.createRegisterData()).passive(false).pull(false).build();
            }
        };
    }

    private DNSSource getDnsSource() {
        return new DNSSourceBuilder().appCached(false).dnsMethod(DNSSource.ResolutionMethod.SYSTEM).build();
    }

    private CompanionRegistrationData createRegisterData() {
        CompanionRegistrationDataBuilder companion = new CompanionRegistrationDataBuilder().buildHash(this.socketHandler.store().version().toHash()).eRegid(this.socketHandler.keys().encodedRegistrationId()).eKeytype(BytesHelper.intToBytes(5, 1)).eIdent(this.socketHandler.keys().identityKeyPair().publicKey()).eSkeyId(this.socketHandler.keys().signedKeyPair().encodedId()).eSkeyVal(this.socketHandler.keys().signedKeyPair().keyPair().publicKey()).eSkeySig(this.socketHandler.keys().signedKeyPair().signature());
        if (this.socketHandler.store().clientType() == ClientType.WEB) {
            CompanionProperties props = this.createCompanionProps();
            byte[] encodedProps = props == null ? null : CompanionPropertiesSpec.encode(props);
            companion.companionProps(encodedProps);
        }
        return companion.build();
    }

    private CompanionProperties createCompanionProps() {
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> {
                WebHistoryLength historyLength = this.socketHandler.store().historyLength();
                HistorySyncConfig config = new HistorySyncConfigBuilder().inlineInitialPayloadInE2EeMsg(true).supportBotUserAgentChatHistory(true).storageQuotaMb(historyLength.size()).build();
                yield new CompanionPropertiesBuilder().os(this.socketHandler.store().name()).platformType(CompanionProperties.PlatformType.CHROME).requireFullSync(historyLength.isExtended()).historySyncConfig(config).build();
            }
            case ClientType.MOBILE -> null;
        };
    }
}

