/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.exception.RequestException;
import it.auties.whatsapp.socket.SocketListener;
import it.auties.whatsapp.util.ProxyAuthenticator;
import it.auties.whatsapp.util.Specification;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;

public abstract sealed class SocketSession {
    private static final int MESSAGE_LENGTH = 3;
    final URI proxy;
    final ExecutorService executor;
    final ReentrantLock outputLock;
    SocketListener listener;

    private SocketSession(URI proxy, ExecutorService executor) {
        this.proxy = proxy;
        this.executor = executor;
        this.outputLock = new ReentrantLock(true);
    }

    abstract CompletableFuture<Void> connect(SocketListener var1);

    abstract void disconnect();

    public abstract CompletableFuture<Void> sendBinary(byte[] var1);

    static SocketSession of(URI proxy, ExecutorService executor, boolean webSocket) {
        if (webSocket) {
            return new WebSocketSession(proxy, executor);
        }
        return new RawSocketSession(proxy, executor);
    }

    public static final class WebSocketSession
    extends SocketSession
    implements WebSocket.Listener {
        private WebSocket session;
        private byte[] message;
        private int messageOffset;

        WebSocketSession(URI proxy, ExecutorService executor) {
            super(proxy, executor);
        }

        @Override
        CompletableFuture<Void> connect(SocketListener listener) {
            if (this.session != null) {
                return CompletableFuture.completedFuture(null);
            }
            this.listener = listener;
            return HttpClient.newBuilder().executor(this.executor).proxy(ProxySelector.of((InetSocketAddress)ProxyAuthenticator.getProxy(this.proxy).address())).authenticator(new ProxyAuthenticator()).build().newWebSocketBuilder().buildAsync(Specification.Whatsapp.WEB_SOCKET_ENDPOINT, this).thenAccept(webSocket -> {
                this.session = webSocket;
                listener.onOpen(this);
            });
        }

        @Override
        void disconnect() {
            if (this.session == null) {
                return;
            }
            this.session.sendClose(1000, "");
        }

        @Override
        public CompletableFuture<Void> sendBinary(byte[] bytes) {
            if (this.session == null) {
                return CompletableFuture.completedFuture(null);
            }
            this.outputLock.lock();
            return ((CompletableFuture)this.session.sendBinary(ByteBuffer.wrap(bytes), true).thenRun(this.outputLock::unlock)).exceptionally(exception -> {
                this.outputLock.unlock();
                throw new RequestException((Throwable)exception);
            });
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            this.message = null;
            this.listener.onClose();
            this.session = null;
            return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            this.listener.onError(error);
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            if (this.message == null) {
                int length = data.get() << 16 | Short.toUnsignedInt(data.getShort());
                if (length < 0) {
                    return WebSocket.Listener.super.onBinary(webSocket, data, last);
                }
                this.message = new byte[length];
                this.messageOffset = 0;
            }
            int currentDataLength = data.remaining();
            int remainingDataLength = this.message.length - this.messageOffset;
            int actualDataLength = Math.min(currentDataLength, remainingDataLength);
            data.get(this.message, this.messageOffset, actualDataLength);
            this.messageOffset += actualDataLength;
            if (this.messageOffset != this.message.length) {
                return WebSocket.Listener.super.onBinary(webSocket, data, last);
            }
            this.notifyMessage();
            if (remainingDataLength - currentDataLength != 0) {
                return this.onBinary(webSocket, data, true);
            }
            return WebSocket.Listener.super.onBinary(webSocket, data, last);
        }

        private void notifyMessage() {
            try {
                this.listener.onMessage(this.message);
            }
            catch (Throwable throwable) {
                this.listener.onError(throwable);
            }
            finally {
                this.message = null;
            }
        }
    }

    static final class RawSocketSession
    extends SocketSession {
        private Socket socket;

        RawSocketSession(URI proxy, ExecutorService executor) {
            super(proxy, executor);
        }

        @Override
        CompletableFuture<Void> connect(SocketListener listener) {
            this.listener = listener;
            if (this.isOpen()) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.runAsync(() -> {
                try {
                    this.socket = new Socket(ProxyAuthenticator.getProxy(this.proxy));
                    this.socket.connect(new InetSocketAddress("g.whatsapp.net", 443));
                    listener.onOpen(this);
                    this.executor.execute(this::readNextMessage);
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(exception);
                }
            });
        }

        private void readNextMessage() {
            while (this.isOpen()) {
                try {
                    byte[] data;
                    int length;
                    byte[] lengthBytes = this.readBytes(3);
                    if (lengthBytes == null || (length = lengthBytes[0] << 16 | (lengthBytes[1] & 0xFF) << 8 | lengthBytes[2] & 0xFF) < 0 || (data = this.readBytes(length)) == null) continue;
                    this.listener.onMessage(data);
                }
                catch (Throwable throwable) {
                    this.listener.onError(throwable);
                }
            }
            this.disconnect();
        }

        private byte[] readBytes(int size) {
            try {
                int chunk;
                byte[] data = new byte[size];
                for (int read = 0; read != data.length; read += chunk) {
                    chunk = this.socket.getInputStream().read(data, read, data.length - read);
                }
                return data;
            }
            catch (Throwable exception) {
                return null;
            }
        }

        @Override
        void disconnect() {
            if (this.socket == null) {
                return;
            }
            try {
                this.listener.onClose();
                this.socket.close();
                this.socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private boolean isOpen() {
            return this.socket != null && !this.socket.isClosed();
        }

        @Override
        public CompletableFuture<Void> sendBinary(byte[] bytes) {
            if (this.socket == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.runAsync(() -> {
                try {
                    this.outputLock.lock();
                    this.socket.getOutputStream().write(bytes);
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(exception);
                }
                finally {
                    this.outputLock.unlock();
                }
            });
        }

        static {
            Authenticator.setDefault(new ProxyAuthenticator());
        }
    }
}

