/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Validate;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class KeyHelper {
    private static final String SHA_PRNG = "SHA1PRNG";

    public static byte[] withHeader(byte[] key) {
        if (key == null) {
            return null;
        }
        return switch (key.length) {
            case 33 -> key;
            case 32 -> KeyHelper.writeKeyHeader(key);
            default -> throw new IllegalArgumentException("Invalid key size: %s".formatted(key.length));
        };
    }

    private static byte[] writeKeyHeader(byte[] key) {
        Validate.isTrue(key.length == 32, "Invalid key size: %s", key.length);
        byte[] result = new byte[33];
        System.arraycopy(key, 0, result, 1, key.length);
        result[0] = 5;
        return result;
    }

    public static byte[] withoutHeader(byte[] key) {
        if (key == null) {
            return null;
        }
        return switch (key.length) {
            case 32 -> key;
            case 33 -> Arrays.copyOfRange(key, 1, key.length);
            default -> throw new IllegalArgumentException("Invalid key size: %s".formatted(key.length));
        };
    }

    public static int header() {
        try {
            byte[] key = new byte[1];
            SecureRandom secureRandom = SecureRandom.getInstance(SHA_PRNG);
            secureRandom.nextBytes(key);
            return 1 + (0xF & key[0]);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new UnsupportedOperationException("Missing ShaPRNG implementation");
        }
    }

    public static int registrationId() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(SHA_PRNG);
            return secureRandom.nextInt(16380) + 1;
        }
        catch (NoSuchAlgorithmException exception) {
            throw new UnsupportedOperationException("Missing ShaPRNG implementation");
        }
    }

    public static byte[] identityId() {
        return BytesHelper.random(16);
    }

    public static byte[] deviceId() {
        return HexFormat.of().parseHex(UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public static String fdid() {
        return UUID.randomUUID().toString();
    }

    public static byte[] senderKey() {
        try {
            byte[] key = new byte[32];
            SecureRandom secureRandom = SecureRandom.getInstance(SHA_PRNG);
            secureRandom.nextBytes(key);
            return key;
        }
        catch (NoSuchAlgorithmException exception) {
            throw new UnsupportedOperationException("Missing ShaPRNG implementation");
        }
    }

    public static int senderKeyId() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(SHA_PRNG);
            return secureRandom.nextInt(0, Integer.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new UnsupportedOperationException("Missing ShaPRNG implementation");
        }
    }

    public static int agent() {
        return ThreadLocalRandom.current().nextInt(800000000, 900000000);
    }

    public static byte[] appKeyId() {
        return BytesHelper.intToBytes(ThreadLocalRandom.current().nextInt(19000, 20000), 6);
    }
}

