package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.MuteAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class MuteActionSpec {
    public static byte[] encode(MuteAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.muted());
var muteEndTimestampSeconds = protoInputObject.muteEndTimestampSeconds();
var muteEndTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(muteEndTimestampSeconds);
if(muteEndTimestampSeconds0 != null) {
outputStream.writeInt64(2, muteEndTimestampSeconds0);
}
outputStream.writeBool(3, protoInputObject.autoMuted());
      return outputStream.toByteArray();
    }

    public static MuteAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean muted = false;
        java.util.OptionalLong muteEndTimestampSeconds = java.util.OptionalLong.empty();
        boolean autoMuted = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> muted = inputStream.readBool();
                case 2 -> muteEndTimestampSeconds = it.auties.protobuf.extension.OptionalExtension.ofNullableLong(inputStream.readInt64());
                case 3 -> autoMuted = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.MuteAction(muted, muteEndTimestampSeconds, autoMuted);
    }

}
