package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.RemoveRecentStickerAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class RemoveRecentStickerActionSpec {
    public static byte[] encode(RemoveRecentStickerAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt64(1, protoInputObject.lastStickerSentTimestampSeconds());
      return outputStream.toByteArray();
    }

    public static RemoveRecentStickerAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        long lastStickerSentTimestampSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> lastStickerSentTimestampSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.RemoveRecentStickerAction(lastStickerSentTimestampSeconds);
    }

}
