package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.SubscriptionAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SubscriptionActionSpec {
    public static byte[] encode(SubscriptionAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.deactivated());
outputStream.writeBool(2, protoInputObject.autoRenewing());
outputStream.writeInt64(3, protoInputObject.expirationDateSeconds());
      return outputStream.toByteArray();
    }

    public static SubscriptionAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean deactivated = false;
        boolean autoRenewing = false;
        long expirationDateSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> deactivated = inputStream.readBool();
                case 2 -> autoRenewing = inputStream.readBool();
                case 3 -> expirationDateSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.SubscriptionAction(deactivated, autoRenewing, expirationDateSeconds);
    }

}
