package it.auties.whatsapp.model.button.base;

import it.auties.whatsapp.model.button.base.Button;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonSpec {
    public static byte[] encode(Button protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
var bodyText = protoInputObject.bodyText();
var bodyText0 = bodyText.orElse(null);
if(bodyText0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.button.base.ButtonTextSpec.encode(bodyText0));
}
var bodyNativeFlow = protoInputObject.bodyNativeFlow();
var bodyNativeFlow0 = bodyNativeFlow.orElse(null);
if(bodyNativeFlow0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.info.NativeFlowInfoSpec.encode(bodyNativeFlow0));
}
outputStream.writeInt32(3, it.auties.whatsapp.model.button.base.ButtonBodyTypeSpec.encode(protoInputObject.bodyType()));
      return outputStream.toByteArray();
    }

    public static Button decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        java.util.Optional<it.auties.whatsapp.model.button.base.ButtonText> bodyText = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.info.NativeFlowInfo> bodyNativeFlow = java.util.Optional.empty();
        it.auties.whatsapp.model.button.base.ButtonBody.Type bodyType = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> bodyText = java.util.Optional.ofNullable(it.auties.whatsapp.model.button.base.ButtonTextSpec.decode(inputStream.readBytes()));
                case 4 -> bodyNativeFlow = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.NativeFlowInfoSpec.decode(inputStream.readBytes()));
                case 3 -> bodyType = it.auties.whatsapp.model.button.base.ButtonBodyTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.base.Button(id, bodyText, bodyNativeFlow, bodyType);
    }

}
