package it.auties.whatsapp.model.button.misc;

import it.auties.whatsapp.model.button.misc.ButtonRow;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonRowSpec {
    public static byte[] encode(ButtonRow protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.title());
outputStream.writeString(2, protoInputObject.description());
outputStream.writeString(3, protoInputObject.id());
      return outputStream.toByteArray();
    }

    public static ButtonRow decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String title = null;
        java.lang.String description = null;
        java.lang.String id = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> title = inputStream.readString();
                case 2 -> description = inputStream.readString();
                case 3 -> id = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.misc.ButtonRow(title, description, id);
    }

}
