package it.auties.whatsapp.model.button.misc;

import it.auties.whatsapp.model.button.misc.ButtonSection;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonSectionSpec {
    public static byte[] encode(ButtonSection protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.title());
      if(protoInputObject.rows() != null) {
       for(var rowsEntry : protoInputObject.rows()) {
outputStream.writeBytes(2, it.auties.whatsapp.model.button.misc.ButtonRowSpec.encode(rowsEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static ButtonSection decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String title = null;
        java.util.List<it.auties.whatsapp.model.button.misc.ButtonRow> rows = new java.util.ArrayList<it.auties.whatsapp.model.button.misc.ButtonRow>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> title = inputStream.readString();
                case 2 -> rows.add(it.auties.whatsapp.model.button.misc.ButtonRowSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.misc.ButtonSection(title, rows);
    }

}
