package it.auties.whatsapp.model.button.template.hydrated;

import it.auties.whatsapp.model.button.template.hydrated.HydratedQuickReplyButton;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HydratedQuickReplyButtonSpec {
    public static byte[] encode(HydratedQuickReplyButton protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.text());
outputStream.writeString(2, protoInputObject.id());
      return outputStream.toByteArray();
    }

    public static HydratedQuickReplyButton decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String text = null;
        java.lang.String id = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> text = inputStream.readString();
                case 2 -> id = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.template.hydrated.HydratedQuickReplyButton(text, id);
    }

}
