package it.auties.whatsapp.model.chat;

import it.auties.whatsapp.model.chat.GroupPastParticipant;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class GroupPastParticipantSpec {
    public static byte[] encode(GroupPastParticipant protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var jid = protoInputObject.jid();
if(jid != null) {
var jid0 = jid.toString();
if(jid0 != null) {
outputStream.writeString(1, jid0);
}
}
outputStream.writeInt32(2, it.auties.whatsapp.model.chat.GroupPastParticipantReasonSpec.encode(protoInputObject.reason()));
outputStream.writeUInt64(3, protoInputObject.timestampSeconds());
      return outputStream.toByteArray();
    }

    public static GroupPastParticipant decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid jid = null;
        it.auties.whatsapp.model.chat.GroupPastParticipant.Reason reason = null;
        long timestampSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> jid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> reason = it.auties.whatsapp.model.chat.GroupPastParticipantReasonSpec.decode(inputStream.readInt32()).orElse(null);
                case 3 -> timestampSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.chat.GroupPastParticipant(jid, reason, timestampSeconds);
    }

}
