package it.auties.whatsapp.model.companion;

import it.auties.whatsapp.model.companion.CompanionHashState;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CompanionHashStateSpec {
    public static byte[] encode(CompanionHashState protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.sync.PatchTypeSpec.encode(protoInputObject.type()));
outputStream.writeInt64(2, protoInputObject.version());
outputStream.writeBytes(3, protoInputObject.hash());
      if(protoInputObject.indexValueMap() != null) {
            for(var indexValueMapEntry : protoInputObject.indexValueMap().entrySet()) {
                var indexValueMapOutputStream = new ProtobufOutputStream();
indexValueMapOutputStream.writeString(1, indexValueMapEntry.getKey());
indexValueMapOutputStream.writeBytes(2, indexValueMapEntry.getValue());
                outputStream.writeBytes(4, indexValueMapOutputStream.toByteArray());
            }
      }
      return outputStream.toByteArray();
    }

    public static CompanionHashState decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.PatchType type = null;
        long version = 0l;
        byte[] hash = null;
        java.util.Map<java.lang.String,byte[]> indexValueMap = new java.util.HashMap<java.lang.String,byte[]>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> type = it.auties.whatsapp.model.sync.PatchTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> version = inputStream.readInt64();
                case 3 -> hash = inputStream.readBytes();
                case 4 -> {
                        var indexValueMapInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.String indexValueMapKey = null;
                        byte[] indexValueMapValue = null;
                        while(indexValueMapInputStream.readTag()) {
                            switch(indexValueMapInputStream.index()) {
                                case 1 -> indexValueMapKey = indexValueMapInputStream.readString();
                                case 2 -> indexValueMapValue = indexValueMapInputStream.readBytes();
                            }
                        }
                        indexValueMap.put(indexValueMapKey, indexValueMapValue);
                }
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.companion.CompanionHashState(type, version, hash, indexValueMap);
    }

}
