package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ChatMessageInfoSpec {
    public static byte[] encode(ChatMessageInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.key()));
outputStream.writeBytes(2, it.auties.whatsapp.model.message.model.MessageContainerSpec.encode(protoInputObject.message()));
var timestampSeconds = protoInputObject.timestampSeconds();
var timestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(timestampSeconds);
if(timestampSeconds0 != null) {
outputStream.writeUInt64(3, timestampSeconds0);
}
outputStream.writeInt32(4, it.auties.whatsapp.model.message.model.MessageStatusSpec.encode(protoInputObject.status()));
var senderJid = protoInputObject.senderJid();
if(senderJid != null) {
var senderJid0 = senderJid.toString();
if(senderJid0 != null) {
outputStream.writeString(5, senderJid0);
}
}
outputStream.writeUInt64(6, protoInputObject.messageC2STimestamp());
outputStream.writeBool(16, protoInputObject.ignore());
outputStream.writeBool(17, protoInputObject.starred());
outputStream.writeBool(18, protoInputObject.broadcast());
var pushName = protoInputObject.pushName();
if(pushName != null) {
var pushName0 = pushName.orElse(null);
if(pushName0 != null) {
outputStream.writeString(19, pushName0);
}
}
var mediaCiphertextSha256 = protoInputObject.mediaCiphertextSha256();
if(mediaCiphertextSha256 != null) {
var mediaCiphertextSha2560 = mediaCiphertextSha256.orElse(null);
if(mediaCiphertextSha2560 != null) {
outputStream.writeBytes(20, mediaCiphertextSha2560);
}
}
outputStream.writeBool(21, protoInputObject.multicast());
outputStream.writeBool(22, protoInputObject.urlText());
outputStream.writeBool(23, protoInputObject.urlNumber());
var stubType = protoInputObject.stubType();
if(stubType != null) {
var stubType0 = stubType.orElse(null);
if(stubType0 != null) {
outputStream.writeInt32(24, it.auties.whatsapp.model.info.ChatMessageInfoStubTypeSpec.encode(stubType0));
}
}
outputStream.writeBool(25, protoInputObject.clearMedia());
      if(protoInputObject.stubParameters() != null) {
       for(var stubParametersEntry : protoInputObject.stubParameters()) {
outputStream.writeString(26, stubParametersEntry);
       }
      }
outputStream.writeUInt32(27, protoInputObject.duration());
      if(protoInputObject.labels() != null) {
       for(var labelsEntry : protoInputObject.labels()) {
outputStream.writeString(28, labelsEntry);
       }
      }
var paymentInfo = protoInputObject.paymentInfo();
if(paymentInfo != null) {
var paymentInfo0 = paymentInfo.orElse(null);
if(paymentInfo0 != null) {
outputStream.writeBytes(29, it.auties.whatsapp.model.info.PaymentInfoSpec.encode(paymentInfo0));
}
}
var finalLiveLocation = protoInputObject.finalLiveLocation();
if(finalLiveLocation != null) {
var finalLiveLocation0 = finalLiveLocation.orElse(null);
if(finalLiveLocation0 != null) {
outputStream.writeBytes(30, it.auties.whatsapp.model.message.standard.LiveLocationMessageSpec.encode(finalLiveLocation0));
}
}
var quotedPaymentInfo = protoInputObject.quotedPaymentInfo();
if(quotedPaymentInfo != null) {
var quotedPaymentInfo0 = quotedPaymentInfo.orElse(null);
if(quotedPaymentInfo0 != null) {
outputStream.writeBytes(31, it.auties.whatsapp.model.info.PaymentInfoSpec.encode(quotedPaymentInfo0));
}
}
outputStream.writeUInt64(32, protoInputObject.ephemeralStartTimestamp());
outputStream.writeUInt32(33, protoInputObject.ephemeralDuration());
outputStream.writeBool(34, protoInputObject.enableEphemeral());
outputStream.writeBool(35, protoInputObject.ephemeralOutOfSync());
var businessPrivacyStatus = protoInputObject.businessPrivacyStatus();
if(businessPrivacyStatus != null) {
var businessPrivacyStatus0 = businessPrivacyStatus.orElse(null);
if(businessPrivacyStatus0 != null) {
outputStream.writeInt32(36, it.auties.whatsapp.model.business.BusinessPrivacyStatusSpec.encode(businessPrivacyStatus0));
}
}
var businessVerifiedName = protoInputObject.businessVerifiedName();
if(businessVerifiedName != null) {
var businessVerifiedName0 = businessVerifiedName.orElse(null);
if(businessVerifiedName0 != null) {
outputStream.writeString(37, businessVerifiedName0);
}
}
var mediaData = protoInputObject.mediaData();
if(mediaData != null) {
var mediaData0 = mediaData.orElse(null);
if(mediaData0 != null) {
outputStream.writeBytes(38, it.auties.whatsapp.model.media.MediaDataSpec.encode(mediaData0));
}
}
var photoChange = protoInputObject.photoChange();
if(photoChange != null) {
var photoChange0 = photoChange.orElse(null);
if(photoChange0 != null) {
outputStream.writeBytes(39, it.auties.whatsapp.model.sync.PhotoChangeSpec.encode(photoChange0));
}
}
outputStream.writeBytes(40, it.auties.whatsapp.model.message.model.MessageReceiptSpec.encode(protoInputObject.receipt()));
      if(protoInputObject.reactions() != null) {
       for(var reactionsEntry : protoInputObject.reactions()) {
outputStream.writeBytes(41, it.auties.whatsapp.model.message.standard.ReactionMessageSpec.encode(reactionsEntry));
       }
      }
var quotedStickerData = protoInputObject.quotedStickerData();
if(quotedStickerData != null) {
var quotedStickerData0 = quotedStickerData.orElse(null);
if(quotedStickerData0 != null) {
outputStream.writeBytes(42, it.auties.whatsapp.model.media.MediaDataSpec.encode(quotedStickerData0));
}
}
outputStream.writeBytes(43, protoInputObject.futureProofData());
var psaStatus = protoInputObject.psaStatus();
if(psaStatus != null) {
var psaStatus0 = psaStatus.orElse(null);
if(psaStatus0 != null) {
outputStream.writeBytes(44, it.auties.whatsapp.model.message.model.PublicServiceAnnouncementStatusSpec.encode(psaStatus0));
}
}
      if(protoInputObject.pollUpdates() != null) {
       for(var pollUpdatesEntry : protoInputObject.pollUpdates()) {
outputStream.writeBytes(45, it.auties.whatsapp.model.poll.PollUpdateSpec.encode(pollUpdatesEntry));
       }
      }
var pollAdditionalMetadata = protoInputObject.pollAdditionalMetadata();
if(pollAdditionalMetadata != null) {
var pollAdditionalMetadata0 = pollAdditionalMetadata.orElse(null);
if(pollAdditionalMetadata0 != null) {
outputStream.writeBytes(46, it.auties.whatsapp.model.poll.PollAdditionalMetadataSpec.encode(pollAdditionalMetadata0));
}
}
var agentId = protoInputObject.agentId();
if(agentId != null) {
var agentId0 = agentId.orElse(null);
if(agentId0 != null) {
outputStream.writeString(47, agentId0);
}
}
outputStream.writeBool(48, protoInputObject.statusAlreadyViewed());
var messageSecret = protoInputObject.messageSecret();
if(messageSecret != null) {
var messageSecret0 = messageSecret.orElse(null);
if(messageSecret0 != null) {
outputStream.writeBytes(49, messageSecret0);
}
}
var keepInChat = protoInputObject.keepInChat();
if(keepInChat != null) {
var keepInChat0 = keepInChat.orElse(null);
if(keepInChat0 != null) {
outputStream.writeBytes(50, it.auties.whatsapp.model.message.model.KeepInChatSpec.encode(keepInChat0));
}
}
var originalSender = protoInputObject.originalSender();
if(originalSender != null) {
var originalSender0 = originalSender.orElse(null);
if(originalSender0 != null) {
var originalSender1 = originalSender0.toString();
if(originalSender1 != null) {
outputStream.writeString(51, originalSender1);
}
}
}
outputStream.writeUInt64(52, protoInputObject.revokeTimestampSeconds());
      return outputStream.toByteArray();
    }

    public static ChatMessageInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey key = null;
        it.auties.whatsapp.model.message.model.MessageContainer message = null;
        long timestampSeconds = 0l;
        it.auties.whatsapp.model.message.model.MessageStatus status = null;
        it.auties.whatsapp.model.jid.Jid senderJid = null;
        long messageC2STimestamp = 0l;
        boolean ignore = false;
        boolean starred = false;
        boolean broadcast = false;
        java.lang.String pushName = null;
        byte[] mediaCiphertextSha256 = null;
        boolean multicast = false;
        boolean urlText = false;
        boolean urlNumber = false;
        it.auties.whatsapp.model.info.ChatMessageInfo.StubType stubType = null;
        boolean clearMedia = false;
        java.util.List<java.lang.String> stubParameters = new java.util.ArrayList<java.lang.String>();
        int duration = 0;
        java.util.List<java.lang.String> labels = new java.util.ArrayList<java.lang.String>();
        it.auties.whatsapp.model.info.PaymentInfo paymentInfo = null;
        it.auties.whatsapp.model.message.standard.LiveLocationMessage finalLiveLocation = null;
        it.auties.whatsapp.model.info.PaymentInfo quotedPaymentInfo = null;
        long ephemeralStartTimestamp = 0l;
        int ephemeralDuration = 0;
        boolean enableEphemeral = false;
        boolean ephemeralOutOfSync = false;
        it.auties.whatsapp.model.business.BusinessPrivacyStatus businessPrivacyStatus = null;
        java.lang.String businessVerifiedName = null;
        it.auties.whatsapp.model.media.MediaData mediaData = null;
        it.auties.whatsapp.model.sync.PhotoChange photoChange = null;
        it.auties.whatsapp.model.message.model.MessageReceipt receipt = null;
        java.util.List<it.auties.whatsapp.model.message.standard.ReactionMessage> reactions = new java.util.ArrayList<it.auties.whatsapp.model.message.standard.ReactionMessage>();
        it.auties.whatsapp.model.media.MediaData quotedStickerData = null;
        byte[] futureProofData = null;
        it.auties.whatsapp.model.message.model.PublicServiceAnnouncementStatus psaStatus = null;
        java.util.List<it.auties.whatsapp.model.poll.PollUpdate> pollUpdates = new java.util.ArrayList<it.auties.whatsapp.model.poll.PollUpdate>();
        it.auties.whatsapp.model.poll.PollAdditionalMetadata pollAdditionalMetadata = null;
        java.lang.String agentId = null;
        boolean statusAlreadyViewed = false;
        byte[] messageSecret = null;
        it.auties.whatsapp.model.message.model.KeepInChat keepInChat = null;
        it.auties.whatsapp.model.jid.Jid originalSender = null;
        long revokeTimestampSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> key = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> message = it.auties.whatsapp.model.message.model.MessageContainerSpec.decode(inputStream.readBytes());
                case 3 -> timestampSeconds = inputStream.readInt64();
                case 4 -> status = it.auties.whatsapp.model.message.model.MessageStatusSpec.decode(inputStream.readInt32()).orElse(null);
                case 5 -> senderJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 6 -> messageC2STimestamp = inputStream.readInt64();
                case 16 -> ignore = inputStream.readBool();
                case 17 -> starred = inputStream.readBool();
                case 18 -> broadcast = inputStream.readBool();
                case 19 -> pushName = inputStream.readString();
                case 20 -> mediaCiphertextSha256 = inputStream.readBytes();
                case 21 -> multicast = inputStream.readBool();
                case 22 -> urlText = inputStream.readBool();
                case 23 -> urlNumber = inputStream.readBool();
                case 24 -> stubType = it.auties.whatsapp.model.info.ChatMessageInfoStubTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 25 -> clearMedia = inputStream.readBool();
                case 26 -> stubParameters.add(inputStream.readString());
                case 27 -> duration = inputStream.readInt32();
                case 28 -> labels.add(inputStream.readString());
                case 29 -> paymentInfo = it.auties.whatsapp.model.info.PaymentInfoSpec.decode(inputStream.readBytes());
                case 30 -> finalLiveLocation = it.auties.whatsapp.model.message.standard.LiveLocationMessageSpec.decode(inputStream.readBytes());
                case 31 -> quotedPaymentInfo = it.auties.whatsapp.model.info.PaymentInfoSpec.decode(inputStream.readBytes());
                case 32 -> ephemeralStartTimestamp = inputStream.readInt64();
                case 33 -> ephemeralDuration = inputStream.readInt32();
                case 34 -> enableEphemeral = inputStream.readBool();
                case 35 -> ephemeralOutOfSync = inputStream.readBool();
                case 36 -> businessPrivacyStatus = it.auties.whatsapp.model.business.BusinessPrivacyStatusSpec.decode(inputStream.readInt32()).orElse(null);
                case 37 -> businessVerifiedName = inputStream.readString();
                case 38 -> mediaData = it.auties.whatsapp.model.media.MediaDataSpec.decode(inputStream.readBytes());
                case 39 -> photoChange = it.auties.whatsapp.model.sync.PhotoChangeSpec.decode(inputStream.readBytes());
                case 40 -> receipt = it.auties.whatsapp.model.message.model.MessageReceiptSpec.decode(inputStream.readBytes());
                case 41 -> reactions.add(it.auties.whatsapp.model.message.standard.ReactionMessageSpec.decode(inputStream.readBytes()));
                case 42 -> quotedStickerData = it.auties.whatsapp.model.media.MediaDataSpec.decode(inputStream.readBytes());
                case 43 -> futureProofData = inputStream.readBytes();
                case 44 -> psaStatus = it.auties.whatsapp.model.message.model.PublicServiceAnnouncementStatusSpec.decode(inputStream.readBytes());
                case 45 -> pollUpdates.add(it.auties.whatsapp.model.poll.PollUpdateSpec.decode(inputStream.readBytes()));
                case 46 -> pollAdditionalMetadata = it.auties.whatsapp.model.poll.PollAdditionalMetadataSpec.decode(inputStream.readBytes());
                case 47 -> agentId = inputStream.readString();
                case 48 -> statusAlreadyViewed = inputStream.readBool();
                case 49 -> messageSecret = inputStream.readBytes();
                case 50 -> keepInChat = it.auties.whatsapp.model.message.model.KeepInChatSpec.decode(inputStream.readBytes());
                case 51 -> originalSender = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 52 -> revokeTimestampSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.ChatMessageInfo(key, message, timestampSeconds, status, senderJid, messageC2STimestamp, ignore, starred, broadcast, pushName, mediaCiphertextSha256, multicast, urlText, urlNumber, stubType, clearMedia, stubParameters, duration, labels, paymentInfo, finalLiveLocation, quotedPaymentInfo, ephemeralStartTimestamp, ephemeralDuration, enableEphemeral, ephemeralOutOfSync, businessPrivacyStatus, businessVerifiedName, mediaData, photoChange, receipt, reactions, quotedStickerData, futureProofData, psaStatus, pollUpdates, pollAdditionalMetadata, agentId, statusAlreadyViewed, messageSecret, keepInChat, originalSender, revokeTimestampSeconds);
    }

}
