package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterMessageInfoSpec {
    public static byte[] encode(NewsletterMessageInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeInt32(2, protoInputObject.serverId());
var timestampSeconds = protoInputObject.timestampSeconds();
if(timestampSeconds != null) {
var timestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(timestampSeconds);
if(timestampSeconds0 != null) {
outputStream.writeUInt64(3, timestampSeconds0);
}
}
var views = protoInputObject.views();
if(views != null) {
var views0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(views);
if(views0 != null) {
outputStream.writeUInt64(4, views0);
}
}
      if(protoInputObject.reactions != null) {
            for(var reactionsEntry : protoInputObject.reactions.entrySet()) {
                var reactionsOutputStream = new ProtobufOutputStream();
reactionsOutputStream.writeString(1, reactionsEntry.getKey());
reactionsOutputStream.writeBytes(2, it.auties.whatsapp.model.newsletter.NewsletterReactionSpec.encode(reactionsEntry.getValue()));
                outputStream.writeBytes(5, reactionsOutputStream.toByteArray());
            }
      }
outputStream.writeBytes(6, it.auties.whatsapp.model.message.model.MessageContainerSpec.encode(protoInputObject.message()));
outputStream.writeInt32(7, it.auties.whatsapp.model.message.model.MessageStatusSpec.encode(protoInputObject.status()));
      return outputStream.toByteArray();
    }

    public static NewsletterMessageInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        int serverId = 0;
        java.lang.Long timestampSeconds = null;
        java.lang.Long views = null;
        java.util.Map<java.lang.String,it.auties.whatsapp.model.newsletter.NewsletterReaction> reactions = new java.util.HashMap<java.lang.String,it.auties.whatsapp.model.newsletter.NewsletterReaction>();
        it.auties.whatsapp.model.message.model.MessageContainer message = null;
        it.auties.whatsapp.model.message.model.MessageStatus status = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> serverId = inputStream.readInt32();
                case 3 -> timestampSeconds = inputStream.readInt64();
                case 4 -> views = inputStream.readInt64();
                case 5 -> {
                        var reactionsInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.String reactionsKey = null;
                        it.auties.whatsapp.model.newsletter.NewsletterReaction reactionsValue = null;
                        while(reactionsInputStream.readTag()) {
                            switch(reactionsInputStream.index()) {
                                case 1 -> reactionsKey = reactionsInputStream.readString();
                                case 2 -> reactionsValue = it.auties.whatsapp.model.newsletter.NewsletterReactionSpec.decode(reactionsInputStream.readBytes());
                            }
                        }
                        reactions.put(reactionsKey, reactionsValue);
                }
                case 6 -> message = it.auties.whatsapp.model.message.model.MessageContainerSpec.decode(inputStream.readBytes());
                case 7 -> status = it.auties.whatsapp.model.message.model.MessageStatusSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.NewsletterMessageInfo(id, serverId, timestampSeconds, views, reactions, message, status);
    }

}
