package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.WebNotificationsInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class WebNotificationsInfoSpec {
    public static byte[] encode(WebNotificationsInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt64(2, protoInputObject.timestampSeconds());
outputStream.writeUInt32(3, protoInputObject.unreadChats());
outputStream.writeUInt32(4, protoInputObject.notifyMessageCount());
      if(protoInputObject.notifyMessages() != null) {
       for(var notifyMessagesEntry : protoInputObject.notifyMessages()) {
outputStream.writeBytes(5, it.auties.whatsapp.model.info.ChatMessageInfoSpec.encode(notifyMessagesEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static WebNotificationsInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        long timestampSeconds = 0l;
        int unreadChats = 0;
        int notifyMessageCount = 0;
        java.util.List<it.auties.whatsapp.model.info.ChatMessageInfo> notifyMessages = new java.util.ArrayList<it.auties.whatsapp.model.info.ChatMessageInfo>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 2 -> timestampSeconds = inputStream.readInt64();
                case 3 -> unreadChats = inputStream.readInt32();
                case 4 -> notifyMessageCount = inputStream.readInt32();
                case 5 -> notifyMessages.add(it.auties.whatsapp.model.info.ChatMessageInfoSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.WebNotificationsInfo(timestampSeconds, unreadChats, notifyMessageCount, notifyMessages);
    }

}
