package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.InteractiveMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InteractiveMessageSpec {
    public static byte[] encode(InteractiveMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var header = protoInputObject.header();
if(header != null) {
var header0 = header.orElse(null);
if(header0 != null) {
outputStream.writeBytes(1, it.auties.whatsapp.model.button.interactive.InteractiveHeaderSpec.encode(header0));
}
}
var body = protoInputObject.body();
if(body != null) {
var body0 = body.orElse(null);
if(body0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.button.interactive.InteractiveBodySpec.encode(body0));
}
}
var footer = protoInputObject.footer();
if(footer != null) {
var footer0 = footer.orElse(null);
if(footer0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.button.interactive.InteractiveFooterSpec.encode(footer0));
}
}
var contentShop = protoInputObject.contentShop();
if(contentShop != null) {
var contentShop0 = contentShop.orElse(null);
if(contentShop0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.button.interactive.InteractiveShopSpec.encode(contentShop0));
}
}
var contentCollection = protoInputObject.contentCollection();
if(contentCollection != null) {
var contentCollection0 = contentCollection.orElse(null);
if(contentCollection0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.button.interactive.InteractiveCollectionSpec.encode(contentCollection0));
}
}
var contentNativeFlow = protoInputObject.contentNativeFlow();
if(contentNativeFlow != null) {
var contentNativeFlow0 = contentNativeFlow.orElse(null);
if(contentNativeFlow0 != null) {
outputStream.writeBytes(6, it.auties.whatsapp.model.button.interactive.InteractiveNativeFlowSpec.encode(contentNativeFlow0));
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(15, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static InteractiveMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.button.interactive.InteractiveHeader header = null;
        it.auties.whatsapp.model.button.interactive.InteractiveBody body = null;
        it.auties.whatsapp.model.button.interactive.InteractiveFooter footer = null;
        it.auties.whatsapp.model.button.interactive.InteractiveShop contentShop = null;
        it.auties.whatsapp.model.button.interactive.InteractiveCollection contentCollection = null;
        it.auties.whatsapp.model.button.interactive.InteractiveNativeFlow contentNativeFlow = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> header = it.auties.whatsapp.model.button.interactive.InteractiveHeaderSpec.decode(inputStream.readBytes());
                case 2 -> body = it.auties.whatsapp.model.button.interactive.InteractiveBodySpec.decode(inputStream.readBytes());
                case 3 -> footer = it.auties.whatsapp.model.button.interactive.InteractiveFooterSpec.decode(inputStream.readBytes());
                case 4 -> contentShop = it.auties.whatsapp.model.button.interactive.InteractiveShopSpec.decode(inputStream.readBytes());
                case 5 -> contentCollection = it.auties.whatsapp.model.button.interactive.InteractiveCollectionSpec.decode(inputStream.readBytes());
                case 6 -> contentNativeFlow = it.auties.whatsapp.model.button.interactive.InteractiveNativeFlowSpec.decode(inputStream.readBytes());
                case 15 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.InteractiveMessage(header, body, footer, contentShop, contentCollection, contentNativeFlow, contextInfo);
    }

}
