package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.InteractiveResponseMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InteractiveResponseMessageSpec {
    public static byte[] encode(InteractiveResponseMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.button.interactive.InteractiveBodySpec.encode(protoInputObject.body()));
outputStream.writeBytes(2, it.auties.whatsapp.model.message.button.NativeFlowResponseMessageSpec.encode(protoInputObject.nativeFlowResponseMessage()));
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(15, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static InteractiveResponseMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.button.interactive.InteractiveBody body = null;
        it.auties.whatsapp.model.message.button.NativeFlowResponseMessage nativeFlowResponseMessage = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> body = it.auties.whatsapp.model.button.interactive.InteractiveBodySpec.decode(inputStream.readBytes());
                case 2 -> nativeFlowResponseMessage = it.auties.whatsapp.model.message.button.NativeFlowResponseMessageSpec.decode(inputStream.readBytes());
                case 15 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.InteractiveResponseMessage(body, nativeFlowResponseMessage, contextInfo);
    }

}
