package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.message.model.KeepInChat;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class KeepInChatSpec {
    public static byte[] encode(KeepInChat protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.message.model.KeepInChatTypeSpec.encode(protoInputObject.keepType()));
outputStream.writeInt64(2, protoInputObject.serverTimestampSeconds());
outputStream.writeBytes(3, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.key()));
var deviceJid = protoInputObject.deviceJid();
if(deviceJid != null) {
var deviceJid0 = deviceJid.toString();
if(deviceJid0 != null) {
outputStream.writeString(4, deviceJid0);
}
}
outputStream.writeInt64(5, protoInputObject.clientTimestampInMilliseconds());
outputStream.writeInt64(6, protoInputObject.serverTimestampMilliseconds());
      return outputStream.toByteArray();
    }

    public static KeepInChat decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.KeepInChatType keepType = null;
        long serverTimestampSeconds = 0l;
        it.auties.whatsapp.model.message.model.ChatMessageKey key = null;
        it.auties.whatsapp.model.jid.Jid deviceJid = null;
        long clientTimestampInMilliseconds = 0l;
        long serverTimestampMilliseconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> keepType = it.auties.whatsapp.model.message.model.KeepInChatTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> serverTimestampSeconds = inputStream.readInt64();
                case 3 -> key = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 4 -> deviceJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 5 -> clientTimestampInMilliseconds = inputStream.readInt64();
                case 6 -> serverTimestampMilliseconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.model.KeepInChat(keepType, serverTimestampSeconds, key, deviceJid, clientTimestampInMilliseconds, serverTimestampMilliseconds);
    }

}
