package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.EmptyMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class EmptyMessageSpec {
    public static byte[] encode(EmptyMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
      return outputStream.toByteArray();
    }

    public static EmptyMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.EmptyMessage();
    }

}
