package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.NewsletterAdminInviteMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterAdminInviteMessageSpec {
    public static byte[] encode(NewsletterAdminInviteMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var newsletterJid = protoInputObject.newsletterJid();
if(newsletterJid != null) {
var newsletterJid0 = newsletterJid.toString();
if(newsletterJid0 != null) {
outputStream.writeString(1, newsletterJid0);
}
}
outputStream.writeString(2, protoInputObject.newsletterName());
outputStream.writeBytes(3, protoInputObject.jpegThumbnail());
outputStream.writeString(4, protoInputObject.caption());
outputStream.writeInt64(5, protoInputObject.inviteExpirationTimestampSeconds());
      return outputStream.toByteArray();
    }

    public static NewsletterAdminInviteMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid newsletterJid = null;
        java.lang.String newsletterName = null;
        byte[] jpegThumbnail = null;
        java.lang.String caption = null;
        long inviteExpirationTimestampSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> newsletterJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> newsletterName = inputStream.readString();
                case 3 -> jpegThumbnail = inputStream.readBytes();
                case 4 -> caption = inputStream.readString();
                case 5 -> inviteExpirationTimestampSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.NewsletterAdminInviteMessage(newsletterJid, newsletterName, jpegThumbnail, caption, inviteExpirationTimestampSeconds);
    }

}
