package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.StickerMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class StickerMessageSpec {
    public static byte[] encode(StickerMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var mediaUrl = protoInputObject.mediaUrl();
if(mediaUrl != null) {
var mediaUrl0 = mediaUrl.orElse(null);
if(mediaUrl0 != null) {
outputStream.writeString(1, mediaUrl0);
}
}
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(2, mediaSha2560);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(3, mediaEncryptedSha2560);
}
}
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(4, mediaKey0);
}
}
var mimetype = protoInputObject.mimetype();
if(mimetype != null) {
var mimetype0 = mimetype.orElse(null);
if(mimetype0 != null) {
outputStream.writeString(5, mimetype0);
}
}
var height = protoInputObject.height();
if(height != null) {
var height0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(height);
if(height0 != null) {
outputStream.writeUInt32(6, height0);
}
}
var width = protoInputObject.width();
if(width != null) {
var width0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(width);
if(width0 != null) {
outputStream.writeUInt32(7, width0);
}
}
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(8, mediaDirectPath0);
}
}
var mediaSize = protoInputObject.mediaSize();
if(mediaSize != null) {
var mediaSize0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaSize);
if(mediaSize0 != null) {
outputStream.writeUInt64(9, mediaSize0);
}
}
var mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds();
if(mediaKeyTimestampSeconds != null) {
var mediaKeyTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaKeyTimestampSeconds);
if(mediaKeyTimestampSeconds0 != null) {
outputStream.writeUInt64(10, mediaKeyTimestampSeconds0);
}
}
var firstFrameLength = protoInputObject.firstFrameLength();
if(firstFrameLength != null) {
var firstFrameLength0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(firstFrameLength);
if(firstFrameLength0 != null) {
outputStream.writeUInt32(11, firstFrameLength0);
}
}
var firstFrameSidecar = protoInputObject.firstFrameSidecar();
if(firstFrameSidecar != null) {
var firstFrameSidecar0 = firstFrameSidecar.orElse(null);
if(firstFrameSidecar0 != null) {
outputStream.writeBytes(12, firstFrameSidecar0);
}
}
outputStream.writeBool(13, protoInputObject.animated());
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
var stickerSentTimestamp = protoInputObject.stickerSentTimestamp();
if(stickerSentTimestamp != null) {
var stickerSentTimestamp0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(stickerSentTimestamp);
if(stickerSentTimestamp0 != null) {
outputStream.writeInt64(18, stickerSentTimestamp0);
}
}
outputStream.writeBool(19, protoInputObject.avatar());
      return outputStream.toByteArray();
    }

    public static StickerMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String mediaUrl = null;
        byte[] mediaSha256 = null;
        byte[] mediaEncryptedSha256 = null;
        byte[] mediaKey = null;
        java.lang.String mimetype = null;
        java.lang.Integer height = null;
        java.lang.Integer width = null;
        java.lang.String mediaDirectPath = null;
        java.lang.Long mediaSize = null;
        java.lang.Long mediaKeyTimestampSeconds = null;
        java.lang.Integer firstFrameLength = null;
        byte[] firstFrameSidecar = null;
        boolean animated = false;
        byte[] thumbnail = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        java.lang.Long stickerSentTimestamp = null;
        boolean avatar = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaUrl = inputStream.readString();
                case 2 -> mediaSha256 = inputStream.readBytes();
                case 3 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 4 -> mediaKey = inputStream.readBytes();
                case 5 -> mimetype = inputStream.readString();
                case 6 -> height = inputStream.readInt32();
                case 7 -> width = inputStream.readInt32();
                case 8 -> mediaDirectPath = inputStream.readString();
                case 9 -> mediaSize = inputStream.readInt64();
                case 10 -> mediaKeyTimestampSeconds = inputStream.readInt64();
                case 11 -> firstFrameLength = inputStream.readInt32();
                case 12 -> firstFrameSidecar = inputStream.readBytes();
                case 13 -> animated = inputStream.readBool();
                case 16 -> thumbnail = inputStream.readBytes();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                case 18 -> stickerSentTimestamp = inputStream.readInt64();
                case 19 -> avatar = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.StickerMessage(mediaUrl, mediaSha256, mediaEncryptedSha256, mediaKey, mimetype, height, width, mediaDirectPath, mediaSize, mediaKeyTimestampSeconds, firstFrameLength, firstFrameSidecar, animated, thumbnail, contextInfo, stickerSentTimestamp, avatar);
    }

}
