package it.auties.whatsapp.model.newsletter;

import it.auties.whatsapp.model.newsletter.NewsletterMetadata;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterMetadataSpec {
    public static byte[] encode(NewsletterMetadata protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var name = protoInputObject.name();
var name0 = name.orElse(null);
if(name0 != null) {
outputStream.writeBytes(1, it.auties.whatsapp.model.newsletter.NewsletterNameSpec.encode(name0));
}
var description = protoInputObject.description();
var description0 = description.orElse(null);
if(description0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.newsletter.NewsletterDescriptionSpec.encode(description0));
}
var picture = protoInputObject.picture();
var picture0 = picture.orElse(null);
if(picture0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.newsletter.NewsletterPictureSpec.encode(picture0));
}
var handle = protoInputObject.handle();
var handle0 = handle.orElse(null);
if(handle0 != null) {
outputStream.writeString(4, handle0);
}
var settings = protoInputObject.settings();
var settings0 = settings.orElse(null);
if(settings0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.newsletter.NewsletterSettingsSpec.encode(settings0));
}
var invite = protoInputObject.invite();
var invite0 = invite.orElse(null);
if(invite0 != null) {
outputStream.writeString(6, invite0);
}
var verification = protoInputObject.verification();
var verification0 = verification.orElse(null);
if(verification0 != null) {
outputStream.writeBool(7, verification0);
}
var creationTimestampSeconds = protoInputObject.creationTimestampSeconds();
var creationTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(creationTimestampSeconds);
if(creationTimestampSeconds0 != null) {
outputStream.writeUInt64(8, creationTimestampSeconds0);
}
      return outputStream.toByteArray();
    }

    public static NewsletterMetadata decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.Optional<it.auties.whatsapp.model.newsletter.NewsletterName> name = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.newsletter.NewsletterDescription> description = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.newsletter.NewsletterPicture> picture = java.util.Optional.empty();
        java.util.Optional<java.lang.String> handle = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.newsletter.NewsletterSettings> settings = java.util.Optional.empty();
        java.util.Optional<java.lang.String> invite = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> verification = java.util.Optional.empty();
        java.util.OptionalLong creationTimestampSeconds = java.util.OptionalLong.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> name = java.util.Optional.ofNullable(it.auties.whatsapp.model.newsletter.NewsletterNameSpec.decode(inputStream.readBytes()));
                case 2 -> description = java.util.Optional.ofNullable(it.auties.whatsapp.model.newsletter.NewsletterDescriptionSpec.decode(inputStream.readBytes()));
                case 3 -> picture = java.util.Optional.ofNullable(it.auties.whatsapp.model.newsletter.NewsletterPictureSpec.decode(inputStream.readBytes()));
                case 4 -> handle = java.util.Optional.ofNullable(inputStream.readString());
                case 5 -> settings = java.util.Optional.ofNullable(it.auties.whatsapp.model.newsletter.NewsletterSettingsSpec.decode(inputStream.readBytes()));
                case 6 -> invite = java.util.Optional.ofNullable(inputStream.readString());
                case 7 -> verification = java.util.Optional.ofNullable(inputStream.readBool());
                case 8 -> creationTimestampSeconds = it.auties.protobuf.extension.OptionalExtension.ofNullableLong(inputStream.readInt64());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.newsletter.NewsletterMetadata(name, description, picture, handle, settings, invite, verification, creationTimestampSeconds);
    }

}
