package it.auties.whatsapp.model.newsletter;

import it.auties.whatsapp.model.newsletter.NewsletterPicture;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterPictureSpec {
    public static byte[] encode(NewsletterPicture protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeString(2, protoInputObject.type());
outputStream.writeString(3, protoInputObject.directPath());
      return outputStream.toByteArray();
    }

    public static NewsletterPicture decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        java.lang.String type = null;
        java.lang.String directPath = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> type = inputStream.readString();
                case 3 -> directPath = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.newsletter.NewsletterPicture(id, type, directPath);
    }

}
