package it.auties.whatsapp.model.newsletter;

import it.auties.whatsapp.model.newsletter.NewsletterSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterSettingsSpec {
    public static byte[] encode(NewsletterSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.newsletter.NewsletterReactionSettingsSpec.encode(protoInputObject.reactionCodes()));
      return outputStream.toByteArray();
    }

    public static NewsletterSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.newsletter.NewsletterReactionSettings reactionCodes = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> reactionCodes = it.auties.whatsapp.model.newsletter.NewsletterReactionSettingsSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.newsletter.NewsletterSettings(reactionCodes);
    }

}
