package it.auties.whatsapp.model.newsletter;

import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterSpec {
    public static byte[] encode(Newsletter protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var jid = protoInputObject.jid();
if(jid != null) {
var jid0 = jid.toString();
if(jid0 != null) {
outputStream.writeString(1, jid0);
}
}
var state = protoInputObject.state();
if(state != null) {
var state0 = state.orElse(null);
if(state0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.newsletter.NewsletterStateSpec.encode(state0));
}
}
outputStream.writeBytes(3, it.auties.whatsapp.model.newsletter.NewsletterMetadataSpec.encode(protoInputObject.metadata()));
var viewerMetadata = protoInputObject.viewerMetadata();
if(viewerMetadata != null) {
var viewerMetadata0 = viewerMetadata.orElse(null);
if(viewerMetadata0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.newsletter.NewsletterViewerMetadataSpec.encode(viewerMetadata0));
}
}
      if(protoInputObject.messages() != null) {
       for(var messagesEntry : protoInputObject.messages()) {
outputStream.writeBytes(5, it.auties.whatsapp.model.info.NewsletterMessageInfoSpec.encode(messagesEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static Newsletter decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid jid = null;
        it.auties.whatsapp.model.newsletter.NewsletterState state = null;
        it.auties.whatsapp.model.newsletter.NewsletterMetadata metadata = null;
        it.auties.whatsapp.model.newsletter.NewsletterViewerMetadata viewerMetadata = null;
        it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue<it.auties.whatsapp.model.info.NewsletterMessageInfo> messages = new it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue<it.auties.whatsapp.model.info.NewsletterMessageInfo>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> jid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> state = it.auties.whatsapp.model.newsletter.NewsletterStateSpec.decode(inputStream.readBytes());
                case 3 -> metadata = it.auties.whatsapp.model.newsletter.NewsletterMetadataSpec.decode(inputStream.readBytes());
                case 4 -> viewerMetadata = it.auties.whatsapp.model.newsletter.NewsletterViewerMetadataSpec.decode(inputStream.readBytes());
                case 5 -> messages.add(it.auties.whatsapp.model.info.NewsletterMessageInfoSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.newsletter.Newsletter(jid, state, metadata, viewerMetadata, messages);
    }

}
