package it.auties.whatsapp.model.product;

import it.auties.whatsapp.model.product.ProductListHeaderImage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ProductListHeaderImageSpec {
    public static byte[] encode(ProductListHeaderImage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeBytes(2, protoInputObject.thumbnail());
      return outputStream.toByteArray();
    }

    public static ProductListHeaderImage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        byte[] thumbnail = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> thumbnail = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.product.ProductListHeaderImage(id, thumbnail);
    }

}
