package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.DNSSource;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DNSSourceSpec {
    public static byte[] encode(DNSSource protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(15, it.auties.whatsapp.model.signal.auth.DNSSourceResolutionMethodSpec.encode(protoInputObject.dnsMethod()));
outputStream.writeBool(16, protoInputObject.appCached());
      return outputStream.toByteArray();
    }

    public static DNSSource decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.signal.auth.DNSSource.ResolutionMethod dnsMethod = null;
        boolean appCached = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 15 -> dnsMethod = it.auties.whatsapp.model.signal.auth.DNSSourceResolutionMethodSpec.decode(inputStream.readInt32()).orElse(null);
                case 16 -> appCached = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.DNSSource(dnsMethod, appCached);
    }

}
