package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.DeviceIdentity;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DeviceIdentitySpec {
    public static byte[] encode(DeviceIdentity protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt32(1, protoInputObject.rawId());
outputStream.writeUInt64(2, protoInputObject.timestamp());
outputStream.writeUInt32(3, protoInputObject.keyIndex());
      return outputStream.toByteArray();
    }

    public static DeviceIdentity decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int rawId = 0;
        long timestamp = 0l;
        int keyIndex = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> rawId = inputStream.readInt32();
                case 2 -> timestamp = inputStream.readInt64();
                case 3 -> keyIndex = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.DeviceIdentity(rawId, timestamp, keyIndex);
    }

}
