package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.HandshakeMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HandshakeMessageSpec {
    public static byte[] encode(HandshakeMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(2, it.auties.whatsapp.model.signal.auth.ClientHelloSpec.encode(protoInputObject.clientHello()));
outputStream.writeBytes(3, it.auties.whatsapp.model.signal.auth.ServerHelloSpec.encode(protoInputObject.serverHello()));
outputStream.writeBytes(4, it.auties.whatsapp.model.signal.auth.ClientFinishSpec.encode(protoInputObject.clientFinish()));
      return outputStream.toByteArray();
    }

    public static HandshakeMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.signal.auth.ClientHello clientHello = null;
        it.auties.whatsapp.model.signal.auth.ServerHello serverHello = null;
        it.auties.whatsapp.model.signal.auth.ClientFinish clientFinish = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 2 -> clientHello = it.auties.whatsapp.model.signal.auth.ClientHelloSpec.decode(inputStream.readBytes());
                case 3 -> serverHello = it.auties.whatsapp.model.signal.auth.ServerHelloSpec.decode(inputStream.readBytes());
                case 4 -> clientFinish = it.auties.whatsapp.model.signal.auth.ClientFinishSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.HandshakeMessage(clientHello, serverHello, clientFinish);
    }

}
