package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMAC;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignedDeviceIdentityHMACSpec {
    public static byte[] encode(SignedDeviceIdentityHMAC protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.details());
outputStream.writeBytes(2, protoInputObject.hmac());
      return outputStream.toByteArray();
    }

    public static SignedDeviceIdentityHMAC decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] details = null;
        byte[] hmac = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> details = inputStream.readBytes();
                case 2 -> hmac = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMAC(details, hmac);
    }

}
