package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class UserAgentSpec {
    public static byte[] encode(UserAgent protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.signal.auth.UserAgentPlatformTypeSpec.encode(protoInputObject.platform()));
outputStream.writeBytes(2, it.auties.whatsapp.model.signal.auth.VersionSpec.encode(protoInputObject.appVersion()));
outputStream.writeString(3, protoInputObject.mcc());
outputStream.writeString(4, protoInputObject.mnc());
outputStream.writeString(5, protoInputObject.osVersion());
outputStream.writeString(6, protoInputObject.manufacturer());
outputStream.writeString(7, protoInputObject.device());
outputStream.writeString(8, protoInputObject.osBuildNumber());
outputStream.writeString(9, protoInputObject.phoneId());
outputStream.writeInt32(10, it.auties.whatsapp.model.signal.auth.UserAgentReleaseChannelSpec.encode(protoInputObject.releaseChannel()));
outputStream.writeString(11, protoInputObject.localeLanguageIso6391());
outputStream.writeString(12, protoInputObject.localeCountryIso31661Alpha2());
outputStream.writeString(13, protoInputObject.deviceBoard());
      return outputStream.toByteArray();
    }

    public static UserAgent decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.signal.auth.UserAgent.PlatformType platform = null;
        it.auties.whatsapp.model.signal.auth.Version appVersion = null;
        java.lang.String mcc = null;
        java.lang.String mnc = null;
        java.lang.String osVersion = null;
        java.lang.String manufacturer = null;
        java.lang.String device = null;
        java.lang.String osBuildNumber = null;
        java.lang.String phoneId = null;
        it.auties.whatsapp.model.signal.auth.UserAgent.ReleaseChannel releaseChannel = null;
        java.lang.String localeLanguageIso6391 = null;
        java.lang.String localeCountryIso31661Alpha2 = null;
        java.lang.String deviceBoard = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> platform = it.auties.whatsapp.model.signal.auth.UserAgentPlatformTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> appVersion = it.auties.whatsapp.model.signal.auth.VersionSpec.decode(inputStream.readBytes());
                case 3 -> mcc = inputStream.readString();
                case 4 -> mnc = inputStream.readString();
                case 5 -> osVersion = inputStream.readString();
                case 6 -> manufacturer = inputStream.readString();
                case 7 -> device = inputStream.readString();
                case 8 -> osBuildNumber = inputStream.readString();
                case 9 -> phoneId = inputStream.readString();
                case 10 -> releaseChannel = it.auties.whatsapp.model.signal.auth.UserAgentReleaseChannelSpec.decode(inputStream.readInt32()).orElse(null);
                case 11 -> localeLanguageIso6391 = inputStream.readString();
                case 12 -> localeCountryIso31661Alpha2 = inputStream.readString();
                case 13 -> deviceBoard = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.UserAgent(platform, appVersion, mcc, mnc, osVersion, manufacturer, device, osBuildNumber, phoneId, releaseChannel, localeLanguageIso6391, localeCountryIso31661Alpha2, deviceBoard);
    }

}
