package it.auties.whatsapp.model.signal.message;

import it.auties.whatsapp.model.signal.message.SignalPreKeyMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignalPreKeyMessageSpec {
    public static byte[] encode(SignalPreKeyMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt32(1, protoInputObject.preKeyId());
outputStream.writeBytes(2, protoInputObject.baseKey());
outputStream.writeBytes(3, protoInputObject.identityKey());
outputStream.writeBytes(4, protoInputObject.serializedSignalMessage());
outputStream.writeUInt32(5, protoInputObject.registrationId());
outputStream.writeUInt32(6, protoInputObject.signedPreKeyId());
      return outputStream.toByteArray();
    }

    public static SignalPreKeyMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Integer preKeyId = null;
        byte[] baseKey = null;
        byte[] identityKey = null;
        byte[] serializedSignalMessage = null;
        java.lang.Integer registrationId = null;
        java.lang.Integer signedPreKeyId = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> preKeyId = inputStream.readInt32();
                case 2 -> baseKey = inputStream.readBytes();
                case 3 -> identityKey = inputStream.readBytes();
                case 4 -> serializedSignalMessage = inputStream.readBytes();
                case 5 -> registrationId = inputStream.readInt32();
                case 6 -> signedPreKeyId = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.message.SignalPreKeyMessage(preKeyId, baseKey, identityKey, serializedSignalMessage, registrationId, signedPreKeyId);
    }

}
