package it.auties.whatsapp.model.signal.session;

import it.auties.whatsapp.model.signal.session.SessionState;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SessionStateSpec {
    public static byte[] encode(SessionState protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.version());
outputStream.writeInt32(2, protoInputObject.registrationId());
outputStream.writeBytes(3, protoInputObject.baseKey());
outputStream.writeBytes(4, protoInputObject.remoteIdentityKey());
      if(protoInputObject.chains() != null) {
            for(var chainsEntry : protoInputObject.chains().entrySet()) {
                var chainsOutputStream = new ProtobufOutputStream();
chainsOutputStream.writeString(1, chainsEntry.getKey());
chainsOutputStream.writeBytes(2, it.auties.whatsapp.model.signal.session.SessionChainSpec.encode(chainsEntry.getValue()));
                outputStream.writeBytes(5, chainsOutputStream.toByteArray());
            }
      }
outputStream.writeBytes(6, protoInputObject.rootKey());
outputStream.writeBytes(7, it.auties.whatsapp.model.signal.session.SessionPreKeySpec.encode(protoInputObject.pendingPreKey()));
outputStream.writeBytes(8, it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.encode(protoInputObject.ephemeralKeyPair()));
outputStream.writeBytes(9, protoInputObject.lastRemoteEphemeralKey());
outputStream.writeInt32(10, protoInputObject.previousCounter());
outputStream.writeBool(11, protoInputObject.closed());
      return outputStream.toByteArray();
    }

    public static SessionState decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int version = 0;
        int registrationId = 0;
        byte[] baseKey = null;
        byte[] remoteIdentityKey = null;
        java.util.concurrent.ConcurrentHashMap<java.lang.String,it.auties.whatsapp.model.signal.session.SessionChain> chains = new java.util.concurrent.ConcurrentHashMap<java.lang.String,it.auties.whatsapp.model.signal.session.SessionChain>();
        byte[] rootKey = null;
        it.auties.whatsapp.model.signal.session.SessionPreKey pendingPreKey = null;
        it.auties.whatsapp.model.signal.keypair.SignalKeyPair ephemeralKeyPair = null;
        byte[] lastRemoteEphemeralKey = null;
        int previousCounter = 0;
        boolean closed = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> version = inputStream.readInt32();
                case 2 -> registrationId = inputStream.readInt32();
                case 3 -> baseKey = inputStream.readBytes();
                case 4 -> remoteIdentityKey = inputStream.readBytes();
                case 5 -> {
                        var chainsInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.String chainsKey = null;
                        it.auties.whatsapp.model.signal.session.SessionChain chainsValue = null;
                        while(chainsInputStream.readTag()) {
                            switch(chainsInputStream.index()) {
                                case 1 -> chainsKey = chainsInputStream.readString();
                                case 2 -> chainsValue = it.auties.whatsapp.model.signal.session.SessionChainSpec.decode(chainsInputStream.readBytes());
                            }
                        }
                        chains.put(chainsKey, chainsValue);
                }
                case 6 -> rootKey = inputStream.readBytes();
                case 7 -> pendingPreKey = it.auties.whatsapp.model.signal.session.SessionPreKeySpec.decode(inputStream.readBytes());
                case 8 -> ephemeralKeyPair = it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.decode(inputStream.readBytes());
                case 9 -> lastRemoteEphemeralKey = inputStream.readBytes();
                case 10 -> previousCounter = inputStream.readInt32();
                case 11 -> closed = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.session.SessionState(version, registrationId, baseKey, remoteIdentityKey, chains, rootKey, pendingPreKey, ephemeralKeyPair, lastRemoteEphemeralKey, previousCounter, closed);
    }

}
