package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.ActionDataSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ActionDataSyncSpec {
    public static byte[] encode(ActionDataSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.index());
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.ActionValueSyncSpec.encode(protoInputObject.value()));
outputStream.writeBytes(3, protoInputObject.padding());
outputStream.writeInt32(4, protoInputObject.version());
      return outputStream.toByteArray();
    }

    public static ActionDataSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] index = null;
        it.auties.whatsapp.model.sync.ActionValueSync value = null;
        byte[] padding = null;
        java.lang.Integer version = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> index = inputStream.readBytes();
                case 2 -> value = it.auties.whatsapp.model.sync.ActionValueSyncSpec.decode(inputStream.readBytes());
                case 3 -> padding = inputStream.readBytes();
                case 4 -> version = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.ActionDataSync(index, value, padding, version);
    }

}
