package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.HistorySyncConfig;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HistorySyncConfigSpec {
    public static byte[] encode(HistorySyncConfig protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt32(1, protoInputObject.fullSyncDaysLimit());
outputStream.writeUInt32(2, protoInputObject.fullSyncSizeMbLimit());
outputStream.writeUInt32(3, protoInputObject.storageQuotaMb());
outputStream.writeBool(4, protoInputObject.inlineInitialPayloadInE2EeMsg());
outputStream.writeUInt32(5, protoInputObject.recentSyncDaysLimit());
outputStream.writeBool(6, protoInputObject.supportCallLogHistory());
outputStream.writeBool(7, protoInputObject.supportBotUserAgentChatHistory());
      return outputStream.toByteArray();
    }

    public static HistorySyncConfig decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Integer fullSyncDaysLimit = null;
        java.lang.Integer fullSyncSizeMbLimit = null;
        java.lang.Integer storageQuotaMb = null;
        java.lang.Boolean inlineInitialPayloadInE2EeMsg = null;
        java.lang.Integer recentSyncDaysLimit = null;
        java.lang.Boolean supportCallLogHistory = null;
        java.lang.Boolean supportBotUserAgentChatHistory = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> fullSyncDaysLimit = inputStream.readInt32();
                case 2 -> fullSyncSizeMbLimit = inputStream.readInt32();
                case 3 -> storageQuotaMb = inputStream.readInt32();
                case 4 -> inlineInitialPayloadInE2EeMsg = inputStream.readBool();
                case 5 -> recentSyncDaysLimit = inputStream.readInt32();
                case 6 -> supportCallLogHistory = inputStream.readBool();
                case 7 -> supportBotUserAgentChatHistory = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.HistorySyncConfig(fullSyncDaysLimit, fullSyncSizeMbLimit, storageQuotaMb, inlineInitialPayloadInE2EeMsg, recentSyncDaysLimit, supportCallLogHistory, supportBotUserAgentChatHistory);
    }

}
