package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.SyncActionMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SyncActionMessageSpec {
    public static byte[] encode(SyncActionMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.key()));
outputStream.writeInt64(2, protoInputObject.timestamp());
      return outputStream.toByteArray();
    }

    public static SyncActionMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey key = null;
        java.lang.Long timestamp = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> key = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> timestamp = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.SyncActionMessage(key, timestamp);
    }

}
