package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.VersionSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class VersionSyncSpec {
    public static byte[] encode(VersionSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt64(1, protoInputObject.version());
      return outputStream.toByteArray();
    }

    public static VersionSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Long version = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> version = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.VersionSync(version);
    }

}
