/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.MobileOptionsBuilder;
import it.auties.whatsapp.api.OptionsBuilder;
import it.auties.whatsapp.api.WebOptionsBuilder;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.KeysBuilder;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.controller.StoreKeysPair;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.mobile.SixPartsKeys;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public final class ConnectionBuilder<T extends OptionsBuilder<T>> {
    private final ClientType clientType;
    private ControllerSerializer serializer;

    ConnectionBuilder(ClientType clientType) {
        this.clientType = clientType;
        this.serializer = ControllerSerializer.toProtobuf();
    }

    public ConnectionBuilder<T> serializer(ControllerSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public T newConnection() {
        return this.newConnection(UUID.randomUUID());
    }

    public T newConnection(UUID uuid) {
        UUID sessionUuid = Objects.requireNonNullElseGet(uuid, UUID::randomUUID);
        StoreKeysPair sessionStoreAndKeys = this.serializer.deserializeStoreKeysPair(sessionUuid, null, null, this.clientType).orElseGet(() -> this.serializer.newStoreKeysPair(sessionUuid, null, null, this.clientType));
        return this.createConnection(sessionStoreAndKeys);
    }

    public T newConnection(long phoneNumber) {
        StoreKeysPair sessionStoreAndKeys = this.serializer.deserializeStoreKeysPair(null, phoneNumber, null, this.clientType).orElseGet(() -> this.serializer.newStoreKeysPair(UUID.randomUUID(), phoneNumber, null, this.clientType));
        return this.createConnection(sessionStoreAndKeys);
    }

    public T newConnection(String alias) {
        StoreKeysPair sessionStoreAndKeys = this.serializer.deserializeStoreKeysPair(null, null, alias, this.clientType).orElseGet(() -> this.serializer.newStoreKeysPair(UUID.randomUUID(), null, alias != null ? List.of(alias) : null, this.clientType));
        return this.createConnection(sessionStoreAndKeys);
    }

    public T newConnection(SixPartsKeys sixParts) {
        Optional<StoreKeysPair> serialized = this.serializer.deserializeStoreKeysPair(null, sixParts.phoneNumber().number(), null, ClientType.MOBILE);
        if (serialized.isPresent()) {
            return this.createConnection(serialized.get());
        }
        UUID uuid = UUID.randomUUID();
        Keys keys = new KeysBuilder().uuid(uuid).phoneNumber(sixParts.phoneNumber()).noiseKeyPair(sixParts.noiseKeyPair()).identityKeyPair(sixParts.identityKeyPair()).identityId(sixParts.identityId()).registered(true).build();
        keys.setSerializer(this.serializer);
        Long phoneNumber = keys.phoneNumber().map(PhoneNumber::number).orElse(null);
        Store store = Store.newStore(uuid, phoneNumber, null, ClientType.MOBILE);
        store.setSerializer(this.serializer);
        return this.createConnection(new StoreKeysPair(store, keys));
    }

    public T firstConnection() {
        return this.newConnection(this.serializer.listIds(this.clientType).peekFirst());
    }

    public T lastConnection() {
        return this.newConnection(this.serializer.listIds(this.clientType).peekLast());
    }

    public Optional<T> newOptionalConnection(UUID uuid) {
        UUID sessionUuid = Objects.requireNonNullElseGet(uuid, UUID::randomUUID);
        return this.serializer.deserializeStoreKeysPair(sessionUuid, null, null, this.clientType).map(this::createConnection);
    }

    public Optional<T> newOptionalConnection(Long phoneNumber) {
        return this.serializer.deserializeStoreKeysPair(null, phoneNumber, null, this.clientType).map(this::createConnection);
    }

    public Optional<T> newOptionalConnection(String alias) {
        return this.serializer.deserializeStoreKeysPair(null, null, alias, this.clientType).map(this::createConnection);
    }

    public Optional<T> firstOptionalConnection() {
        return this.newOptionalConnection(this.serializer.listIds(this.clientType).peekFirst());
    }

    public Optional<T> lastOptionalConnection() {
        return this.newOptionalConnection(this.serializer.listIds(this.clientType).peekLast());
    }

    private T createConnection(StoreKeysPair sessionStoreAndKeys) {
        return (T)(switch (this.clientType) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> new WebOptionsBuilder(sessionStoreAndKeys.store(), sessionStoreAndKeys.keys());
            case ClientType.MOBILE -> new MobileOptionsBuilder(sessionStoreAndKeys.store(), sessionStoreAndKeys.keys());
        });
    }
}

