/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.KeysSpec;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.controller.StoreSpec;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatBuilder;
import it.auties.whatsapp.model.chat.ChatSpec;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterSpec;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class ProtobufControllerSerializer
implements ControllerSerializer {
    private static final Path DEFAULT_SERIALIZER_PATH = Path.of(System.getProperty("user.home") + "/.cobalt/", new String[0]);
    private static final String CHAT_PREFIX = "chat_";
    private static final String NEWSLETTER_PREFIX = "newsletter_";
    private static final String STORE_NAME = "store.proto";
    private static final String KEYS_NAME = "keys.proto";
    private static final Map<Path, ProtobufControllerSerializer> serializers = new ConcurrentHashMap<Path, ProtobufControllerSerializer>();
    private final Path baseDirectory;
    private final ConcurrentMap<UUID, CompletableFuture<Void>> attributeStoreSerializers;
    private LinkedList<UUID> cachedUuids;
    private LinkedList<PhoneNumber> cachedPhoneNumbers;

    public static ControllerSerializer ofDefaultPath() {
        return Objects.requireNonNull(serializers.get(DEFAULT_SERIALIZER_PATH));
    }

    public static ControllerSerializer of(Path baseDirectory) {
        ProtobufControllerSerializer known = serializers.get(baseDirectory);
        if (known != null) {
            return known;
        }
        ProtobufControllerSerializer result = new ProtobufControllerSerializer(baseDirectory);
        serializers.put(baseDirectory, result);
        return result;
    }

    private ProtobufControllerSerializer(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.attributeStoreSerializers = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    }

    @Override
    public LinkedList<UUID> listIds(ClientType type) {
        LinkedList linkedList;
        block10: {
            if (this.cachedUuids != null) {
                return new ImmutableLinkedList<UUID>(this.cachedUuids);
            }
            Path directory = this.getHome(type);
            if (Files.notExists(directory, new LinkOption[0])) {
                return ImmutableLinkedList.empty();
            }
            Stream<Path> walker = Files.walk(directory, 1, new FileVisitOption[0]).sorted(Comparator.comparing(this::getLastModifiedTime));
            try {
                linkedList = this.cachedUuids = walker.map(this::parsePathAsId).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedList::new));
                if (walker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return ImmutableLinkedList.empty();
                }
            }
            walker.close();
        }
        return linkedList;
    }

    @Override
    public LinkedList<PhoneNumber> listPhoneNumbers(ClientType type) {
        LinkedList linkedList;
        block10: {
            if (this.cachedPhoneNumbers != null) {
                return new ImmutableLinkedList<PhoneNumber>(this.cachedPhoneNumbers);
            }
            Path directory = this.getHome(type);
            if (Files.notExists(directory, new LinkOption[0])) {
                return ImmutableLinkedList.empty();
            }
            Stream<Path> walker = Files.walk(directory, 1, new FileVisitOption[0]).sorted(Comparator.comparing(this::getLastModifiedTime));
            try {
                linkedList = this.cachedPhoneNumbers = walker.map(this::parsePathAsPhoneNumber).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedList::new));
                if (walker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return ImmutableLinkedList.empty();
                }
            }
            walker.close();
        }
        return linkedList;
    }

    private FileTime getLastModifiedTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException exception) {
            return FileTime.fromMillis(0L);
        }
    }

    private Optional<UUID> parsePathAsId(Path file) {
        try {
            return Optional.of(UUID.fromString(file.getFileName().toString()));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    private Optional<PhoneNumber> parsePathAsPhoneNumber(Path file) {
        try {
            long longValue = Long.parseLong(file.getFileName().toString());
            return PhoneNumber.ofNullable(longValue);
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    @Override
    public CompletableFuture<Void> serializeKeys(Keys keys, boolean async) {
        if (this.cachedUuids != null && !this.cachedUuids.contains(keys.uuid())) {
            this.cachedUuids.add(keys.uuid());
        }
        Path outputFile = this.getSessionFile(keys.clientType(), keys.uuid().toString(), KEYS_NAME);
        if (async) {
            return CompletableFuture.runAsync(() -> this.writeFile(KeysSpec.encode(keys), KEYS_NAME, outputFile)).exceptionallyAsync(this::onError);
        }
        this.writeFile(KeysSpec.encode(keys), KEYS_NAME, outputFile);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> serializeStore(Store store, boolean async) {
        CompletableFuture task;
        if (this.cachedUuids != null && !this.cachedUuids.contains(store.uuid())) {
            this.cachedUuids.add(store.uuid());
        }
        PhoneNumber phoneNumber = store.phoneNumber().orElse(null);
        if (this.cachedPhoneNumbers != null && !this.cachedPhoneNumbers.contains(phoneNumber)) {
            this.cachedPhoneNumbers.add(phoneNumber);
        }
        if ((task = (CompletableFuture)this.attributeStoreSerializers.get(store.uuid())) != null && !task.isDone()) {
            return task;
        }
        CompletableFuture<?>[] chatsFutures = this.serializeChatsAsync(store);
        CompletableFuture<?>[] newslettersFutures = this.serializeNewslettersAsync(store);
        CompletableFuture[] dependableFutures = (CompletableFuture[])Stream.of(chatsFutures, newslettersFutures).flatMap(Arrays::stream).toArray(CompletableFuture[]::new);
        CompletionStage result = CompletableFuture.allOf(dependableFutures).thenRunAsync(() -> {
            Path storePath = this.getSessionFile(store, STORE_NAME);
            this.writeFile(StoreSpec.encode(store), STORE_NAME, storePath);
        });
        if (async) {
            return result;
        }
        ((CompletableFuture)result).join();
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<?>[] serializeChatsAsync(Store store) {
        return (CompletableFuture[])store.chats().stream().map(chat -> this.serializeChatAsync(store, (Chat)chat)).toArray(CompletableFuture[]::new);
    }

    private CompletableFuture<Void> serializeChatAsync(Store store, Chat chat) {
        if (!chat.hasUpdate()) {
            return CompletableFuture.completedFuture(null);
        }
        String fileName = CHAT_PREFIX + chat.jid().user() + ".proto";
        Path outputFile = this.getSessionFile(store, fileName);
        return CompletableFuture.runAsync(() -> this.writeFile(ChatSpec.encode(chat), fileName, outputFile)).exceptionallyAsync(this::onError);
    }

    private Void onError(Throwable error) {
        System.Logger logger = System.getLogger("Serializer");
        logger.log(System.Logger.Level.ERROR, error);
        return null;
    }

    private CompletableFuture<?>[] serializeNewslettersAsync(Store store) {
        return (CompletableFuture[])store.newsletters().stream().map(newsletter -> this.serializeNewsletterAsync(store, (Newsletter)newsletter)).toArray(CompletableFuture[]::new);
    }

    private CompletableFuture<Void> serializeNewsletterAsync(Store store, Newsletter newsletter) {
        String fileName = NEWSLETTER_PREFIX + newsletter.jid().user() + ".proto";
        Path outputFile = this.getSessionFile(store, fileName);
        return CompletableFuture.runAsync(() -> this.writeFile(NewsletterSpec.encode(newsletter), fileName, outputFile));
    }

    private void writeFile(byte[] object, String fileName, Path outputFile) {
        try {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            Path tempFile = Files.createTempFile(fileName, ".tmp", new FileAttribute[0]);
            try (GZIPOutputStream tempFileOutputStream = new GZIPOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));){
                tempFileOutputStream.write(object);
            }
            Files.move(tempFile, outputFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot write file", exception);
        }
    }

    @Override
    public Optional<Keys> deserializeKeys(ClientType type, UUID id) {
        return this.deserializeKeysFromId(type, id.toString());
    }

    @Override
    public Optional<Keys> deserializeKeys(ClientType type, String alias) {
        Path file = this.getSessionDirectory(type, alias);
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeKeysFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Keys> deserializeKeys(ClientType type, long phoneNumber) {
        Path file = this.getSessionDirectory(type, String.valueOf(phoneNumber));
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeKeysFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    private Optional<Keys> deserializeKeysFromId(ClientType type, String id) {
        Optional<Keys> optional;
        Path path = this.getSessionFile(type, id, KEYS_NAME);
        GZIPInputStream input = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            optional = Optional.of(KeysSpec.decode(input.readAllBytes()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return Optional.empty();
            }
        }
        input.close();
        return optional;
    }

    @Override
    public Optional<Store> deserializeStore(ClientType type, UUID id) {
        return this.deserializeStoreFromId(type, id.toString());
    }

    @Override
    public Optional<Store> deserializeStore(ClientType type, String alias) {
        Path file = this.getSessionDirectory(type, alias);
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeStoreFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Store> deserializeStore(ClientType type, long phoneNumber) {
        Path file = this.getSessionDirectory(type, String.valueOf(phoneNumber));
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeStoreFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    private Optional<Store> deserializeStoreFromId(ClientType type, String id) {
        Optional<Store> optional;
        Path path = this.getSessionFile(type, id, STORE_NAME);
        if (Files.notExists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        GZIPInputStream input = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            optional = Optional.of(StoreSpec.decode(input.readAllBytes()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return Optional.empty();
            }
        }
        input.close();
        return optional;
    }

    @Override
    public CompletableFuture<Void> attributeStore(Store store) {
        CompletionStage completionStage;
        block10: {
            CompletableFuture oldTask = (CompletableFuture)this.attributeStoreSerializers.get(store.uuid());
            if (oldTask != null) {
                return oldTask;
            }
            Path directory = this.getSessionDirectory(store.clientType(), store.uuid().toString());
            if (Files.notExists(directory, new LinkOption[0])) {
                return CompletableFuture.completedFuture(null);
            }
            Stream<Path> walker = Files.walk(directory, new FileVisitOption[0]);
            try {
                CompletableFuture[] futures = (CompletableFuture[])walker.map(entry -> this.handleStoreFile(store, (Path)entry)).filter(Objects::nonNull).toArray(CompletableFuture[]::new);
                CompletionStage result = CompletableFuture.allOf(futures).thenRun(() -> this.attributeStoreContextualMessages(store));
                this.attributeStoreSerializers.put(store.uuid(), (CompletableFuture<Void>)result);
                completionStage = result;
                if (walker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return CompletableFuture.failedFuture(exception);
                }
            }
            walker.close();
        }
        return completionStage;
    }

    private void attributeStoreContextualMessages(Store store) {
        store.chats().stream().flatMap(chat -> chat.messages().stream()).forEach(message -> this.attributeStoreContextualMessage(store, (HistorySyncMessage)message));
    }

    private void attributeStoreContextualMessage(Store store, HistorySyncMessage message) {
        message.messageInfo().message().contentWithContext().flatMap(ContextualMessage::contextInfo).ifPresent(contextInfo -> this.attributeStoreContextInfo(store, (ContextInfo)contextInfo));
    }

    private void attributeStoreContextInfo(Store store, ContextInfo contextInfo) {
        contextInfo.quotedMessageChatJid().flatMap(store::findChatByJid).ifPresent(contextInfo::setQuotedMessageChat);
    }

    private CompletableFuture<Void> handleStoreFile(Store store, Path entry) {
        return switch (FileType.of(entry).ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> CompletableFuture.runAsync(() -> this.deserializeNewsletter(store, entry)).exceptionallyAsync(this::onError);
            case 1 -> CompletableFuture.runAsync(() -> this.deserializeChat(store, entry)).exceptionallyAsync(this::onError);
            case 0 -> null;
        };
    }

    @Override
    public void deleteSession(Controller<?> controller) {
        try {
            Path folderPath = this.getSessionDirectory(controller.clientType(), controller.uuid().toString());
            this.delete(folderPath);
            PhoneNumber phoneNumber = controller.phoneNumber().orElse(null);
            if (phoneNumber == null) {
                return;
            }
            Path linkedFolderPath = this.getSessionDirectory(controller.clientType(), phoneNumber.toString());
            Files.deleteIfExists(linkedFolderPath);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot delete session", exception);
        }
    }

    private void delete(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void linkMetadata(Controller<?> controller) {
        controller.phoneNumber().ifPresent(phoneNumber -> this.linkToUuid(controller.clientType(), controller.uuid(), phoneNumber.toString()));
        controller.alias().forEach(alias -> this.linkToUuid(controller.clientType(), controller.uuid(), (String)alias));
    }

    private void linkToUuid(ClientType type, UUID uuid, String string) {
        try {
            Path link = this.getSessionDirectory(type, string);
            Files.writeString(link, (CharSequence)uuid.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deserializeChat(Store store, Path chatFile) {
        try (GZIPInputStream input = new GZIPInputStream(Files.newInputStream(chatFile, new OpenOption[0]));){
            Chat chat = ChatSpec.decode(input.readAllBytes());
            for (HistorySyncMessage message : chat.messages()) {
                message.messageInfo().setChat(chat);
            }
            store.addChatDirect(chat);
        }
        catch (IOException exception) {
            store.addChatDirect(this.rescueChat(chatFile));
        }
    }

    private Chat rescueChat(Path entry) {
        try {
            Files.deleteIfExists(entry);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String chatName = entry.getFileName().toString().replaceFirst(CHAT_PREFIX, "").replace(".proto", "");
        return new ChatBuilder().jid(Jid.of(chatName)).build();
    }

    private void deserializeNewsletter(Store store, Path newsletterFile) {
        try (GZIPInputStream input = new GZIPInputStream(Files.newInputStream(newsletterFile, new OpenOption[0]));){
            Newsletter newsletter = NewsletterSpec.decode(input.readAllBytes());
            for (NewsletterMessageInfo message : newsletter.messages()) {
                message.setNewsletter(newsletter);
            }
            store.addNewsletter(newsletter);
        }
        catch (IOException exception) {
            store.addNewsletter(this.rescueNewsletter(newsletterFile));
        }
    }

    private Newsletter rescueNewsletter(Path entry) {
        try {
            Files.deleteIfExists(entry);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String newsletterName = entry.getFileName().toString().replaceFirst(CHAT_PREFIX, "").replace(".proto", "");
        return new Newsletter(Jid.of(newsletterName), null, null, null);
    }

    private Path getHome(ClientType type) {
        return this.baseDirectory.resolve(type == ClientType.MOBILE ? "mobile" : "web");
    }

    private Path getSessionDirectory(ClientType clientType, String path) {
        try {
            Path result = this.getHome(clientType).resolve(path);
            Files.createDirectories(result.getParent(), new FileAttribute[0]);
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private Path getSessionFile(Store store, String fileName) {
        try {
            Path result = this.getSessionFile(store.clientType(), store.uuid().toString(), fileName);
            Files.createDirectories(result.getParent(), new FileAttribute[0]);
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot create directory", exception);
        }
    }

    private Path getSessionFile(ClientType clientType, String uuid, String fileName) {
        try {
            Path result = this.getSessionDirectory(clientType, uuid).resolve(fileName);
            Files.createDirectories(result.getParent(), new FileAttribute[0]);
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot create directory", exception);
        }
    }

    static {
        serializers.put(DEFAULT_SERIALIZER_PATH, new ProtobufControllerSerializer(DEFAULT_SERIALIZER_PATH));
    }

    private static class ImmutableLinkedList<E>
    extends LinkedList<E> {
        private static final ImmutableLinkedList EMPTY = new ImmutableLinkedList(new LinkedList());
        private final LinkedList<E> delegate;

        private static <E> ImmutableLinkedList<E> empty() {
            return EMPTY;
        }

        private ImmutableLinkedList(LinkedList<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public E getFirst() {
            return this.delegate.getFirst();
        }

        @Override
        public E getLast() {
            return this.delegate.getLast();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        @Override
        public E peek() {
            return this.delegate.peek();
        }

        @Override
        public E element() {
            return this.delegate.element();
        }

        @Override
        public E poll() {
            return this.delegate.poll();
        }

        @Override
        public boolean offer(E e) {
            return this.delegate.offer(e);
        }

        @Override
        public boolean offerFirst(E e) {
            return this.delegate.offerFirst(e);
        }

        @Override
        public boolean offerLast(E e) {
            return this.delegate.offerLast(e);
        }

        @Override
        public E peekFirst() {
            return this.delegate.peekFirst();
        }

        @Override
        public E peekLast() {
            return this.delegate.peekLast();
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void push(E e) {
            this.delegate.push(e);
        }

        @Override
        public E pop() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.delegate.listIterator(index);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.delegate.descendingIterator();
        }

        @Override
        public Object clone() {
            return this.delegate.clone();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public LinkedList<E> reversed() {
            return this.delegate.reversed();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            this.delegate.sort(c);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.delegate.toArray(generator);
        }

        @Override
        public Stream<E> stream() {
            return this.delegate.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.delegate.forEach(action);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirst(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E removeFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E removeLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum FileType {
        UNKNOWN(null),
        CHAT("chat_"),
        NEWSLETTER("newsletter_");

        private final String prefix;

        private FileType(String prefix) {
            this.prefix = prefix;
        }

        private static FileType of(Path path) {
            return Arrays.stream(FileType.values()).filter(entry -> entry.prefix() != null && path.getFileName().toString().startsWith(entry.prefix())).findFirst().orElse(UNKNOWN);
        }

        private String prefix() {
            return this.prefix;
        }
    }
}

