/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DerOutputStream
extends ByteArrayOutputStream {
    private static final byte tag_Integer = 2;
    private static final byte tag_BitString = 3;
    private static final byte tag_Sequence = 48;

    public void writeSequence(byte[] buf) {
        this.write(48);
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void putInteger(BigInteger i) {
        this.write(2);
        byte[] buf = i.toByteArray();
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void putBitString(byte[] bits) throws IOException {
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(0);
        this.write(bits);
    }

    private void putLength(int len) {
        if (len < 128) {
            this.write((byte)len);
        } else if (len < 256) {
            this.write(-127);
            this.write((byte)len);
        } else if (len < 65536) {
            this.write(-126);
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else if (len < 0x1000000) {
            this.write(-125);
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else {
            this.write(-124);
            this.write((byte)(len >> 24));
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        }
    }
}

