/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PBKDF2 {
    private static final String ALGORITHM = "HMACSHA1";

    public static byte[] hmacSha1With8Bit(byte[] password, byte[] salt, int iterationCount, int keySizeBits) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            SecretKeySpec key = new SecretKeySpec(password, ALGORITHM);
            mac.init(key);
            byte[] state = new byte[mac.getMacLength()];
            int keySize = keySizeBits / 8;
            int blocks = (keySize + mac.getMacLength() - 1) / mac.getMacLength();
            byte[] iBuf = new byte[4];
            byte[] result = new byte[blocks * mac.getMacLength()];
            int offset = 0;
            for (int i = 1; i <= blocks; ++i) {
                int n;
                int pos = 3;
                do {
                    n = pos--;
                } while ((iBuf[n] = (byte)(iBuf[n] + 1)) == 0);
                if (salt != null) {
                    mac.update(salt, 0, salt.length);
                }
                mac.update(iBuf, 0, iBuf.length);
                mac.doFinal(state, 0);
                System.arraycopy(state, 0, result, offset, state.length);
                for (int count = 1; count < iterationCount; ++count) {
                    mac.update(state, 0, state.length);
                    mac.doFinal(state, 0);
                    for (int j = 0; j != state.length; ++j) {
                        int n2 = offset + j;
                        result[n2] = (byte)(result[n2] ^ state[j]);
                    }
                }
                offset += mac.getMacLength();
            }
            return Arrays.copyOf(result, keySize);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new RuntimeException("Missing HMACSHA1 implementation", exception);
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException(exception);
        }
    }
}

