/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.call;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.call.CallStatus;
import it.auties.whatsapp.model.call.CallStatusSpec;
import it.auties.whatsapp.model.jid.Jid;

public class CallSpec {
    public static byte[] encode(Call protoInputObject) {
        String caller0;
        Jid caller;
        String chat0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Jid chat = protoInputObject.chat();
        if (chat != null && (chat0 = chat.toString()) != null) {
            outputStream.writeString(1, chat0);
        }
        if ((caller = protoInputObject.caller()) != null && (caller0 = caller.toString()) != null) {
            outputStream.writeString(2, caller0);
        }
        outputStream.writeString(3, protoInputObject.id());
        outputStream.writeUInt64(4, Long.valueOf(protoInputObject.timestampSeconds()));
        outputStream.writeBool(5, Boolean.valueOf(protoInputObject.video()));
        outputStream.writeInt32(6, CallStatusSpec.encode(protoInputObject.status()));
        outputStream.writeBool(7, Boolean.valueOf(protoInputObject.offline()));
        return outputStream.toByteArray();
    }

    public static Call decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Jid chat = null;
        Jid caller = null;
        String id = null;
        long timestampSeconds = 0L;
        boolean video = false;
        CallStatus status = null;
        boolean offline = false;
        block9: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    chat = Jid.ofProtobuf(inputStream.readString());
                    continue block9;
                }
                case 2: {
                    caller = Jid.ofProtobuf(inputStream.readString());
                    continue block9;
                }
                case 3: {
                    id = inputStream.readString();
                    continue block9;
                }
                case 4: {
                    timestampSeconds = inputStream.readInt64();
                    continue block9;
                }
                case 5: {
                    video = inputStream.readBool();
                    continue block9;
                }
                case 6: {
                    status = CallStatusSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block9;
                }
                case 7: {
                    offline = inputStream.readBool();
                    continue block9;
                }
            }
            inputStream.skipBytes();
        }
        return new Call(chat, caller, id, timestampSeconds, video, status, offline);
    }
}

