/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.chat.ChatDisappearSpec;
import it.auties.whatsapp.model.chat.ChatEndOfHistoryTransferTypeSpec;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.whatsapp.model.chat.ChatWallpaperSpec;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupParticipantSpec;
import it.auties.whatsapp.model.chat.GroupPastParticipant;
import it.auties.whatsapp.model.chat.GroupPastParticipantSpec;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.contact.ContactStatusSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.media.MediaVisibility;
import it.auties.whatsapp.model.media.MediaVisibilitySpec;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.model.sync.HistorySyncMessageSpec;
import it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChatSpec {
    public static byte[] encode(Chat protoInputObject) {
        String lidJid0;
        String phoneJid0;
        String parentGroupJid0;
        String founder0;
        String oldJid0;
        Jid oldJid;
        String newJid0;
        Jid newJid;
        Object jid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        Jid jid = protoInputObject.jid;
        if (jid != null && (jid0 = jid.toString()) != null) {
            outputStream.writeString(1, (String)jid0);
        }
        if (protoInputObject.historySyncMessages != null) {
            for (HistorySyncMessage historySyncMessagesEntry : protoInputObject.historySyncMessages) {
                outputStream.writeBytes(2, HistorySyncMessageSpec.encode(historySyncMessagesEntry));
            }
        }
        if ((newJid = protoInputObject.newJid) != null && (newJid0 = newJid.toString()) != null) {
            outputStream.writeString(3, newJid0);
        }
        if ((oldJid = protoInputObject.oldJid) != null && (oldJid0 = oldJid.toString()) != null) {
            outputStream.writeString(4, oldJid0);
        }
        outputStream.writeUInt32(6, Integer.valueOf(protoInputObject.unreadMessagesCount));
        outputStream.writeBool(7, Boolean.valueOf(protoInputObject.readOnly));
        outputStream.writeBool(8, Boolean.valueOf(protoInputObject.endOfHistoryTransfer));
        ChatEphemeralTimer ephemeralMessageDuration = protoInputObject.ephemeralMessageDuration;
        if (ephemeralMessageDuration != null) {
            int ephemeralMessageDuration0 = ephemeralMessageDuration.periodSeconds();
            outputStream.writeUInt32(9, Integer.valueOf(ephemeralMessageDuration0));
        }
        outputStream.writeInt64(10, Long.valueOf(protoInputObject.ephemeralMessagesToggleTimeSeconds));
        outputStream.writeInt32(11, ChatEndOfHistoryTransferTypeSpec.encode(protoInputObject.endOfHistoryTransferType));
        outputStream.writeUInt64(12, Long.valueOf(protoInputObject.timestampSeconds));
        outputStream.writeString(13, protoInputObject.name);
        outputStream.writeBool(15, Boolean.valueOf(protoInputObject.notSpam));
        outputStream.writeBool(16, Boolean.valueOf(protoInputObject.archived));
        outputStream.writeBytes(17, ChatDisappearSpec.encode(protoInputObject.disappearInitiator));
        outputStream.writeBool(19, Boolean.valueOf(protoInputObject.markedAsUnread));
        if (protoInputObject.participants != null) {
            for (GroupParticipant participantsEntry : protoInputObject.participants) {
                outputStream.writeBytes(20, GroupParticipantSpec.encode(participantsEntry));
            }
        }
        outputStream.writeBytes(21, protoInputObject.token);
        outputStream.writeUInt64(22, Long.valueOf(protoInputObject.tokenTimestampSeconds));
        outputStream.writeBytes(23, protoInputObject.identityKey);
        outputStream.writeUInt32(24, Integer.valueOf(protoInputObject.pinnedTimestampSeconds));
        ChatMute mute = protoInputObject.mute;
        if (mute != null) {
            long mute0 = mute.endTimeStamp();
            outputStream.writeUInt64(25, Long.valueOf(mute0));
        }
        outputStream.writeBytes(26, ChatWallpaperSpec.encode(protoInputObject.wallpaper));
        outputStream.writeInt32(27, MediaVisibilitySpec.encode(protoInputObject.mediaVisibility));
        outputStream.writeUInt64(28, Long.valueOf(protoInputObject.tokenSenderTimestampSeconds));
        outputStream.writeBool(29, Boolean.valueOf(protoInputObject.suspended));
        outputStream.writeBool(30, Boolean.valueOf(protoInputObject.terminated));
        outputStream.writeUInt64(31, Long.valueOf(protoInputObject.foundationTimestampSeconds));
        Jid founder = protoInputObject.founder;
        if (founder != null && (founder0 = founder.toString()) != null) {
            outputStream.writeString(32, founder0);
        }
        outputStream.writeString(33, protoInputObject.description);
        outputStream.writeBool(34, Boolean.valueOf(protoInputObject.support));
        outputStream.writeBool(35, Boolean.valueOf(protoInputObject.parentGroup));
        outputStream.writeBool(36, Boolean.valueOf(protoInputObject.defaultSubGroup));
        Jid parentGroupJid = protoInputObject.parentGroupJid;
        if (parentGroupJid != null && (parentGroupJid0 = parentGroupJid.toString()) != null) {
            outputStream.writeString(37, parentGroupJid0);
        }
        outputStream.writeString(38, protoInputObject.displayName);
        Jid phoneJid = protoInputObject.phoneJid;
        if (phoneJid != null && (phoneJid0 = phoneJid.toString()) != null) {
            outputStream.writeString(39, phoneJid0);
        }
        outputStream.writeBool(40, Boolean.valueOf(protoInputObject.shareOwnPhoneNumber));
        outputStream.writeBool(41, Boolean.valueOf(protoInputObject.pnhDuplicateLidThread));
        Jid lidJid = protoInputObject.lidJid;
        if (lidJid != null && (lidJid0 = lidJid.toString()) != null) {
            outputStream.writeString(42, lidJid0);
        }
        if (protoInputObject.presences != null) {
            for (Map.Entry entry : protoInputObject.presences.entrySet()) {
                String presences0;
                ProtobufOutputStream presencesOutputStream = new ProtobufOutputStream();
                Jid presences = (Jid)entry.getKey();
                if (presences != null && (presences0 = presences.toString()) != null) {
                    presencesOutputStream.writeString(1, presences0);
                }
                presencesOutputStream.writeInt32(2, ContactStatusSpec.encode((ContactStatus)((Object)entry.getValue())));
                outputStream.writeBytes(999, presencesOutputStream.toByteArray());
            }
        }
        if (protoInputObject.participantsPreKeys != null) {
            for (Jid jid2 : protoInputObject.participantsPreKeys) {
                String participantsPreKeys0;
                Jid participantsPreKeys = jid2;
                if (participantsPreKeys == null || (participantsPreKeys0 = participantsPreKeys.toString()) == null) continue;
                outputStream.writeString(1000, participantsPreKeys0);
            }
        }
        if (protoInputObject.pastParticipants != null) {
            for (GroupPastParticipant groupPastParticipant : protoInputObject.pastParticipants) {
                outputStream.writeBytes(1001, GroupPastParticipantSpec.encode(groupPastParticipant));
            }
        }
        return outputStream.toByteArray();
    }

    public static Chat decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        Jid jid = null;
        ConcurrentLinkedHashedDequeue<HistorySyncMessage> historySyncMessages = new ConcurrentLinkedHashedDequeue<HistorySyncMessage>();
        Jid newJid = null;
        Jid oldJid = null;
        int unreadMessagesCount = 0;
        boolean readOnly = false;
        boolean endOfHistoryTransfer = false;
        ChatEphemeralTimer ephemeralMessageDuration = null;
        long ephemeralMessagesToggleTimeSeconds = 0L;
        Chat.EndOfHistoryTransferType endOfHistoryTransferType = null;
        long timestampSeconds = 0L;
        String name = null;
        boolean notSpam = false;
        boolean archived = false;
        ChatDisappear disappearInitiator = null;
        boolean markedAsUnread = false;
        ArrayList<GroupParticipant> participants = new ArrayList<GroupParticipant>();
        byte[] token = null;
        long tokenTimestampSeconds = 0L;
        byte[] identityKey = null;
        int pinnedTimestampSeconds = 0;
        ChatMute mute = null;
        ChatWallpaper wallpaper = null;
        MediaVisibility mediaVisibility = null;
        long tokenSenderTimestampSeconds = 0L;
        boolean suspended = false;
        boolean terminated = false;
        long foundationTimestampSeconds = 0L;
        Jid founder = null;
        String description = null;
        boolean support = false;
        boolean parentGroup = false;
        boolean defaultSubGroup = false;
        Jid parentGroupJid = null;
        String displayName = null;
        Jid phoneJid = null;
        boolean shareOwnPhoneNumber = false;
        boolean pnhDuplicateLidThread = false;
        Jid lidJid = null;
        ConcurrentHashMap<Jid, ContactStatus> presences = new ConcurrentHashMap<Jid, ContactStatus>();
        HashSet<Jid> participantsPreKeys = new HashSet<Jid>();
        HashSet<GroupPastParticipant> pastParticipants = new HashSet<GroupPastParticipant>();
        block48: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    jid = Jid.ofProtobuf(inputStream.readString());
                    continue block48;
                }
                case 2: {
                    historySyncMessages.add(HistorySyncMessageSpec.decode(inputStream.readBytes()));
                    continue block48;
                }
                case 3: {
                    newJid = Jid.ofProtobuf(inputStream.readString());
                    continue block48;
                }
                case 4: {
                    oldJid = Jid.ofProtobuf(inputStream.readString());
                    continue block48;
                }
                case 6: {
                    unreadMessagesCount = inputStream.readInt32();
                    continue block48;
                }
                case 7: {
                    readOnly = inputStream.readBool();
                    continue block48;
                }
                case 8: {
                    endOfHistoryTransfer = inputStream.readBool();
                    continue block48;
                }
                case 9: {
                    ephemeralMessageDuration = ChatEphemeralTimer.of(inputStream.readInt32());
                    continue block48;
                }
                case 10: {
                    ephemeralMessagesToggleTimeSeconds = inputStream.readInt64();
                    continue block48;
                }
                case 11: {
                    endOfHistoryTransferType = ChatEndOfHistoryTransferTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block48;
                }
                case 12: {
                    timestampSeconds = inputStream.readInt64();
                    continue block48;
                }
                case 13: {
                    name = inputStream.readString();
                    continue block48;
                }
                case 15: {
                    notSpam = inputStream.readBool();
                    continue block48;
                }
                case 16: {
                    archived = inputStream.readBool();
                    continue block48;
                }
                case 17: {
                    disappearInitiator = ChatDisappearSpec.decode(inputStream.readBytes());
                    continue block48;
                }
                case 19: {
                    markedAsUnread = inputStream.readBool();
                    continue block48;
                }
                case 20: {
                    participants.add(GroupParticipantSpec.decode(inputStream.readBytes()));
                    continue block48;
                }
                case 21: {
                    token = inputStream.readBytes();
                    continue block48;
                }
                case 22: {
                    tokenTimestampSeconds = inputStream.readInt64();
                    continue block48;
                }
                case 23: {
                    identityKey = inputStream.readBytes();
                    continue block48;
                }
                case 24: {
                    pinnedTimestampSeconds = inputStream.readInt32();
                    continue block48;
                }
                case 25: {
                    mute = ChatMute.ofProtobuf(inputStream.readInt64());
                    continue block48;
                }
                case 26: {
                    wallpaper = ChatWallpaperSpec.decode(inputStream.readBytes());
                    continue block48;
                }
                case 27: {
                    mediaVisibility = MediaVisibilitySpec.decode(inputStream.readInt32()).orElse(null);
                    continue block48;
                }
                case 28: {
                    tokenSenderTimestampSeconds = inputStream.readInt64();
                    continue block48;
                }
                case 29: {
                    suspended = inputStream.readBool();
                    continue block48;
                }
                case 30: {
                    terminated = inputStream.readBool();
                    continue block48;
                }
                case 31: {
                    foundationTimestampSeconds = inputStream.readInt64();
                    continue block48;
                }
                case 32: {
                    founder = Jid.ofProtobuf(inputStream.readString());
                    continue block48;
                }
                case 33: {
                    description = inputStream.readString();
                    continue block48;
                }
                case 34: {
                    support = inputStream.readBool();
                    continue block48;
                }
                case 35: {
                    parentGroup = inputStream.readBool();
                    continue block48;
                }
                case 36: {
                    defaultSubGroup = inputStream.readBool();
                    continue block48;
                }
                case 37: {
                    parentGroupJid = Jid.ofProtobuf(inputStream.readString());
                    continue block48;
                }
                case 38: {
                    displayName = inputStream.readString();
                    continue block48;
                }
                case 39: {
                    phoneJid = Jid.ofProtobuf(inputStream.readString());
                    continue block48;
                }
                case 40: {
                    shareOwnPhoneNumber = inputStream.readBool();
                    continue block48;
                }
                case 41: {
                    pnhDuplicateLidThread = inputStream.readBool();
                    continue block48;
                }
                case 42: {
                    lidJid = Jid.ofProtobuf(inputStream.readString());
                    continue block48;
                }
                case 999: {
                    ProtobufInputStream presencesInputStream = new ProtobufInputStream(inputStream.readBytes());
                    Jid presencesKey = null;
                    ContactStatus presencesValue = null;
                    while (presencesInputStream.readTag()) {
                        switch (presencesInputStream.index()) {
                            case 1: {
                                presencesKey = Jid.ofProtobuf(presencesInputStream.readString());
                                break;
                            }
                            case 2: {
                                presencesValue = ContactStatusSpec.decode(presencesInputStream.readInt32()).orElse(null);
                            }
                        }
                    }
                    presences.put(presencesKey, presencesValue);
                    continue block48;
                }
                case 1000: {
                    participantsPreKeys.add(Jid.ofProtobuf(inputStream.readString()));
                    continue block48;
                }
                case 1001: {
                    pastParticipants.add(GroupPastParticipantSpec.decode(inputStream.readBytes()));
                    continue block48;
                }
            }
            inputStream.skipBytes();
        }
        return new Chat(jid, historySyncMessages, newJid, oldJid, unreadMessagesCount, readOnly, endOfHistoryTransfer, ephemeralMessageDuration, ephemeralMessagesToggleTimeSeconds, endOfHistoryTransferType, timestampSeconds, name, notSpam, archived, disappearInitiator, markedAsUnread, participants, token, tokenTimestampSeconds, identityKey, pinnedTimestampSeconds, mute, wallpaper, mediaVisibility, tokenSenderTimestampSeconds, suspended, terminated, foundationTimestampSeconds, founder, description, support, parentGroup, defaultSubGroup, parentGroupJid, displayName, phoneJid, shareOwnPhoneNumber, pnhDuplicateLidThread, lidJid, presences, participantsPreKeys, pastParticipants);
    }
}

