/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import java.util.Optional;

public class CompanionDeviceBuilder {
    private String model = null;
    private String manufacturer = null;
    private UserAgent.PlatformType platform = null;
    private Optional<Version> appVersion = Optional.empty();
    private Version osVersion = null;

    public CompanionDeviceBuilder model(String model) {
        this.model = model;
        return this;
    }

    public CompanionDeviceBuilder manufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    public CompanionDeviceBuilder platform(UserAgent.PlatformType platform) {
        this.platform = platform;
        return this;
    }

    public CompanionDeviceBuilder appVersion(Optional<Version> appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public CompanionDeviceBuilder appVersion(Version appVersion) {
        this.appVersion = Optional.ofNullable(appVersion);
        return this;
    }

    public CompanionDeviceBuilder osVersion(Version osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public CompanionDevice build() {
        return new CompanionDevice(this.model, this.manufacturer, this.platform, this.appVersion, this.osVersion);
    }
}

