/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.extension.OptionalExtension;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageContainerSpec;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.MessageStatusSpec;
import it.auties.whatsapp.model.newsletter.NewsletterReaction;
import it.auties.whatsapp.model.newsletter.NewsletterReactionSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;

public class NewsletterMessageInfoSpec {
    public static byte[] encode(NewsletterMessageInfo protoInputObject) {
        Long views0;
        OptionalLong views;
        Long timestampSeconds0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeString(1, protoInputObject.id());
        outputStream.writeInt32(2, Integer.valueOf(protoInputObject.serverId()));
        OptionalLong timestampSeconds = protoInputObject.timestampSeconds();
        if (timestampSeconds != null && (timestampSeconds0 = OptionalExtension.toNullableLong((OptionalLong)timestampSeconds)) != null) {
            outputStream.writeUInt64(3, timestampSeconds0);
        }
        if ((views = protoInputObject.views()) != null && (views0 = OptionalExtension.toNullableLong((OptionalLong)views)) != null) {
            outputStream.writeUInt64(4, views0);
        }
        if (protoInputObject.reactions != null) {
            for (Map.Entry<String, NewsletterReaction> reactionsEntry : protoInputObject.reactions.entrySet()) {
                ProtobufOutputStream reactionsOutputStream = new ProtobufOutputStream();
                reactionsOutputStream.writeString(1, reactionsEntry.getKey());
                reactionsOutputStream.writeBytes(2, NewsletterReactionSpec.encode(reactionsEntry.getValue()));
                outputStream.writeBytes(5, reactionsOutputStream.toByteArray());
            }
        }
        outputStream.writeBytes(6, MessageContainerSpec.encode(protoInputObject.message()));
        outputStream.writeInt32(7, MessageStatusSpec.encode(protoInputObject.status()));
        return outputStream.toByteArray();
    }

    public static NewsletterMessageInfo decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String id = null;
        int serverId = 0;
        Long timestampSeconds = null;
        Long views = null;
        HashMap<String, NewsletterReaction> reactions = new HashMap<String, NewsletterReaction>();
        MessageContainer message = null;
        MessageStatus status = null;
        block13: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    id = inputStream.readString();
                    continue block13;
                }
                case 2: {
                    serverId = inputStream.readInt32();
                    continue block13;
                }
                case 3: {
                    timestampSeconds = inputStream.readInt64();
                    continue block13;
                }
                case 4: {
                    views = inputStream.readInt64();
                    continue block13;
                }
                case 5: {
                    ProtobufInputStream reactionsInputStream = new ProtobufInputStream(inputStream.readBytes());
                    String reactionsKey = null;
                    NewsletterReaction reactionsValue = null;
                    while (reactionsInputStream.readTag()) {
                        switch (reactionsInputStream.index()) {
                            case 1: {
                                reactionsKey = reactionsInputStream.readString();
                                break;
                            }
                            case 2: {
                                reactionsValue = NewsletterReactionSpec.decode(reactionsInputStream.readBytes());
                            }
                        }
                    }
                    reactions.put(reactionsKey, reactionsValue);
                    continue block13;
                }
                case 6: {
                    message = MessageContainerSpec.decode(inputStream.readBytes());
                    continue block13;
                }
                case 7: {
                    status = MessageStatusSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block13;
                }
            }
            inputStream.skipBytes();
        }
        return new NewsletterMessageInfo(id, serverId, timestampSeconds, views, reactions, message, status);
    }
}

